/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class WebPage {
    private String name;
    private Date lastMod;
    private ChangeFreq changeFreq;
    private Double priority;
    private String shortDescription;
    private String shortName;

    public String constructUrl(W3CDateFormat dateFormat, String baseUrl) {
        StringBuilder out = new StringBuilder();
        out.append("<url>\n");
        out.append("<loc>");
        try {
            if (this.name != null) {
                out.append(new URL(baseUrl + this.name).toString());
            } else {
                out.append(new URL(baseUrl).toString());
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        out.append("</loc>\n");
        if (this.lastMod != null) {
            out.append("<lastmod>");
            out.append(dateFormat.format(this.lastMod));
            out.append("</lastmod>\n");
        }
        if (this.changeFreq != null) {
            out.append("<changefreq>");
            out.append((Object)this.changeFreq);
            out.append("</changefreq>\n");
        }
        if (this.priority != null) {
            out.append("<priority>");
            out.append(this.priority);
            out.append("</priority>\n");
        }
        out.append("</url>\n");
        return out.toString();
    }

    public String getShortName() {
        return this.shortName;
    }

    public WebPage setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public WebPage setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    public WebPage setName(String name) {
        this.name = name;
        return this;
    }

    public WebPage setLastMod(Date lastMod) {
        this.lastMod = lastMod;
        return this;
    }

    public WebPage setChangeFreq(ChangeFreq changeFreq) {
        this.changeFreq = changeFreq;
        return this;
    }

    public WebPage setPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0 and 1.0");
        }
        this.priority = priority;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastMod() {
        return this.lastMod;
    }

    public ChangeFreq getChangeFreq() {
        return this.changeFreq;
    }

    public Double getPriority() {
        return this.priority;
    }
}

