/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.HttpClientUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.GWTException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class WebSitemapGenerator
extends AbstractGenerator {
    private W3CDateFormat dateFormat = new W3CDateFormat();

    public WebSitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    public String[] constructSitemap() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.add("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
        ArrayList values = new ArrayList(this.urls.values());
        Collections.sort(values);
        for (WebPage webSitemapUrl : values) {
            out.add(webSitemapUrl.constructUrl(this.dateFormat, this.baseUrl));
        }
        out.add("</urlset>");
        return out.toArray(new String[0]);
    }

    public String constructSitemapString() {
        String[] sitemapArray = this.constructSitemap();
        StringBuilder result = new StringBuilder();
        String[] stringArray = sitemapArray;
        int n = sitemapArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            result.append(line);
            ++n2;
        }
        return result.toString();
    }

    public void saveSitemap(File file, String[] sitemap) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        String[] stringArray = sitemap;
        int n = sitemap.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            writer.write(string);
            ++n2;
        }
        writer.close();
    }

    public void constructAndSaveSitemap(File file) throws IOException {
        String[] sitemap = this.constructSitemap();
        this.saveSitemap(file, sitemap);
    }

    public void pingGoogle(String sitemapUrl) {
        this.ping("http://www.google.com/webmasters/tools/ping?sitemap=", sitemapUrl);
    }

    public void pingBing(String sitemapUrl) {
        this.ping("http://www.bing.com/ping?sitemap=", sitemapUrl);
    }

    private void ping(String resourceUrl, String sitemapUrl) {
        try {
            String pingUrl = String.valueOf(resourceUrl) + URLEncoder.encode(sitemapUrl, "UTF-8");
            int returnCode = HttpClientUtil.get(pingUrl);
            if (returnCode != 200) {
                throw new GWTException("Google could not be informed about new sitemap!");
            }
        }
        catch (Exception ex) {
            throw new GWTException("Google could not be informed about new sitemap!");
        }
    }

    public void pingGoogle() {
        this.pingGoogle(String.valueOf(this.baseUrl) + "sitemap.xml");
    }

    public void pingBing() {
        this.pingBing(String.valueOf(this.baseUrl) + "sitemap.xml");
    }
}

