/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.HttpClientUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.exception.GWTException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;

public abstract class AbstractSitemapGenerator
extends AbstractGenerator {
    protected W3CDateFormat dateFormat = new W3CDateFormat();

    public AbstractSitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    public abstract String[] constructSitemap();

    public String constructSitemapString() {
        String[] sitemapArray = this.constructSitemap();
        StringBuilder result = new StringBuilder();
        for (String line : sitemapArray) {
            result.append(line);
        }
        return result.toString();
    }

    public void saveSitemap(File file, String[] sitemap) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        for (String string : sitemap) {
            writer.write(string);
        }
        writer.close();
    }

    public void constructAndSaveSitemap(File file) throws IOException {
        String[] sitemap = this.constructSitemap();
        this.saveSitemap(file, sitemap);
    }

    public void pingGoogle(String sitemapUrl) {
        this.ping("http://www.google.com/webmasters/tools/ping?sitemap=", sitemapUrl);
    }

    public void pingBing(String sitemapUrl) {
        this.ping("http://www.bing.com/ping?sitemap=", sitemapUrl);
    }

    private void ping(String resourceUrl, String sitemapUrl) {
        try {
            String pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
            int returnCode = HttpClientUtil.get(pingUrl);
            if (returnCode != 200) {
                throw new GWTException("Google could not be informed about new sitemap!");
            }
        }
        catch (Exception ex) {
            throw new GWTException("Google could not be informed about new sitemap!");
        }
    }

    public void pingGoogle() {
        this.pingGoogle(this.baseUrl + "sitemap.xml");
    }

    public void pingBing() {
        this.pingBing(this.baseUrl + "sitemap.xml");
    }
}

