/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.Image;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPage
implements Comparable<WebPage> {
    private String name;
    private Date lastMod;
    private ChangeFreq changeFreq;
    private Double priority;
    private String shortDescription;
    private String shortName;
    private List<Image> images;

    public void addImage(Image image) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(image);
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public String getShortName() {
        return this.shortName;
    }

    public WebPage setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public WebPage setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    public WebPage setName(String name) {
        this.name = name;
        return this;
    }

    public WebPage setLastMod(Date lastMod) {
        this.lastMod = lastMod;
        return this;
    }

    public WebPage setChangeFreq(ChangeFreq changeFreq) {
        this.changeFreq = changeFreq;
        return this;
    }

    public WebPage setPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0 and 1.0");
        }
        this.priority = priority;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastMod() {
        return this.lastMod;
    }

    public ChangeFreq getChangeFreq() {
        return this.changeFreq;
    }

    public Double getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(WebPage o) {
        if (this.getPriority() == null && o.getPriority() == null) {
            return 0;
        }
        if (this.getPriority() == null) {
            return 1;
        }
        if (o.getPriority() == null) {
            return -1;
        }
        return -this.getPriority().compareTo(o.getPriority());
    }
}

