/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;

public class RssGenerator
extends AbstractGenerator {
    private static final String DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss";
    private String webTitle;
    private String webDescription;

    public RssGenerator(String baseUrl, boolean root, String webTitle, String webDescription) {
        super(baseUrl, root);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    public RssGenerator(String baseUrl, String webTitle, String webDescription) {
        super(baseUrl);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    public String constructRss() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        builder.append("<rss version=\"2.0\">\n");
        builder.append("<channel>\n");
        builder.append("<title>" + this.webTitle + "</title>\n");
        builder.append("<link>" + this.baseUrl + "</link>\n");
        builder.append("<description>" + this.webDescription + "</description>\n");
        ArrayList webPages = new ArrayList(this.urls.values());
        webPages.sort(Comparator.comparing(WebPage::getLastMod));
        Date latestDate = new Date();
        if (!webPages.isEmpty()) {
            latestDate = ((WebPage)webPages.get(0)).getLastMod();
        }
        builder.append("<pubDate>" + new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate) + " +0000</pubDate>\n");
        builder.append("<lastBuildDate>" + new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate) + " +0000</lastBuildDate>\n");
        builder.append("<ttl>1800</ttl>\n");
        for (WebPage webPage : webPages) {
            builder.append("<item>\n");
            builder.append("<title>");
            builder.append(webPage.getName());
            builder.append("</title>\n");
            builder.append("<description>");
            builder.append(webPage.getShortDescription());
            builder.append("</description>\n");
            builder.append("<link>");
            builder.append(this.baseUrl + webPage.getShortName());
            builder.append("</link>\n");
            builder.append("<pubDate>");
            builder.append(new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(webPage.getLastMod()) + " +0000");
            builder.append("</pubDate>\n");
            builder.append("</item>\n");
        }
        builder.append("</channel>\n");
        builder.append("</rss>\n");
        return builder.toString();
    }

    @Override
    public RssGenerator addPage(WebPage webPage) {
        this.urls.put(this.baseUrl + webPage.getName(), webPage);
        return this;
    }

    @Override
    public RssGenerator addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
        return this;
    }

    @Override
    public <T> RssGenerator addPages(Collection<T> webPages, Function<T, WebPage> mapper) {
        for (T element : webPages) {
            this.addPage(mapper.apply(element));
        }
        return this;
    }
}

