/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.HttpClientUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.exception.GWTException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractSitemapGenerator<T extends AbstractGenerator>
extends AbstractGenerator<T> {
    protected W3CDateFormat dateFormat = new W3CDateFormat();

    public AbstractSitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    public abstract String[] constructSitemap();

    public String constructSitemapString() {
        String[] sitemapArray = this.constructSitemap();
        StringBuilder result = new StringBuilder();
        for (String line : sitemapArray) {
            result.append(line);
        }
        return result.toString();
    }

    private ByteArrayOutputStream gzipIt(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (GZIPOutputStream gzos = new GZIPOutputStream(outputStream);
             InputStream in = inputStream;){
            int len;
            while ((len = in.read(buffer)) > 0) {
                gzos.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot perform gzip", ex);
        }
        return outputStream;
    }

    public byte[] constructSitemapGzip() {
        String sitemap = this.constructSitemapString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sitemap.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream outputStream = this.gzipIt(inputStream);
        return outputStream.toByteArray();
    }

    public void saveSitemap(File file, String[] sitemap) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String string : sitemap) {
                writer.write(string);
            }
        }
    }

    public void constructAndSaveSitemap(File file) throws IOException {
        String[] sitemap = this.constructSitemap();
        this.saveSitemap(file, sitemap);
    }

    public void constructAndSaveSitemap(Path path) throws IOException {
        this.constructAndSaveSitemap(path.toFile());
    }

    public void pingGoogle(String sitemapUrl) {
        this.ping("https://www.google.com/ping?sitemap=", sitemapUrl, "Google");
    }

    public void pingBing(String sitemapUrl) {
        this.ping("http://www.bing.com/ping?sitemap=", sitemapUrl, "Bing");
    }

    private void ping(String resourceUrl, String sitemapUrl, String serviceName) {
        try {
            String pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
            int returnCode = HttpClientUtil.get(pingUrl);
            if (returnCode != 200) {
                throw new GWTException(serviceName + " could not be informed about new sitemap!");
            }
        }
        catch (Exception ex) {
            throw new GWTException(serviceName + " could not be informed about new sitemap!");
        }
    }

    public void pingGoogle() {
        this.pingGoogle(this.baseUrl + "sitemap.xml");
    }

    public void pingBing() {
        this.pingBing(this.baseUrl + "sitemap.xml");
    }

    protected String escapeXmlSpecialCharacters(String url) {
        return url.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

