/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class RssGenerator
extends AbstractGenerator<RssGenerator> {
    private static final String DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss";
    private String webTitle;
    private String webDescription;

    @Deprecated
    public RssGenerator(String baseUrl, boolean root, String webTitle, String webDescription) {
        super(baseUrl, root);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    @Deprecated
    public RssGenerator(String baseUrl, String webTitle, String webDescription) {
        super(baseUrl);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    public static RssGenerator of(String baseUrl, boolean root, String webTitle, String webDescription) {
        return new RssGenerator(baseUrl, root, webTitle, webDescription);
    }

    public static RssGenerator of(String baseUrl, boolean root) {
        return new RssGenerator(baseUrl, root, null, null);
    }

    public static RssGenerator of(String baseUrl, String webTitle, String webDescription) {
        return new RssGenerator(baseUrl, webTitle, webDescription);
    }

    public static RssGenerator of(String baseUrl) {
        return new RssGenerator(baseUrl, null, null);
    }

    public RssGenerator webTitle(String webTitle) {
        this.webTitle = webTitle;
        return this;
    }

    public RssGenerator webDescription(String webDescription) {
        this.webDescription = webDescription;
        return this;
    }

    @Deprecated
    public String constructRss() {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n").append("<rss version=\"2.0\">\n").append("<channel>\n").append("<title>").append(this.webTitle).append("</title>\n").append("<link>").append(this.baseUrl).append("</link>\n").append("<description>").append(this.webDescription).append("</description>\n");
        ArrayList webPages = new ArrayList(this.urls.values());
        webPages.sort(Comparator.comparing(WebPage::getLastMod).reversed());
        Date latestDate = new Date();
        if (!webPages.isEmpty()) {
            latestDate = ((WebPage)webPages.get(0)).getLastMod();
        }
        builder.append("<pubDate>").append(new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate)).append(" +0000</pubDate>\n").append("<lastBuildDate>").append(new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate)).append(" +0000</lastBuildDate>\n").append("<ttl>1800</ttl>\n");
        for (WebPage webPage : webPages) {
            builder.append("<item>\n").append("<title>").append(webPage.constructName()).append("</title>\n").append("<description>").append(webPage.getShortDescription()).append("</description>\n").append("<link>").append(this.baseUrl).append(webPage.getShortName()).append("</link>\n").append("<pubDate>").append(new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(webPage.getLastMod())).append(" +0000").append("</pubDate>\n").append("</item>\n");
        }
        builder.append("</channel>\n").append("</rss>\n");
        return builder.toString();
    }
}

