/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.Image;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class WebPage
implements Comparable<WebPage> {
    private String name;
    private String dir;
    private String extension;
    private Map<String, String> alternateNames;
    private Date lastMod;
    private ChangeFreq changeFreq;
    private Double priority;
    private static final double MIN_PRIORITY = 0.0;
    private static final double MAX_PRIORITY = 1.0;
    private String shortDescription;
    private String shortName;
    private List<Image> images;
    private static final Comparator<Double> PRIORITY_COMPARATOR = (a, b) -> {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return -Double.compare(a, b);
    };
    private static final Comparator<String> SHORT_NAME_COMPARATOR = (a, b) -> {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo((String)b);
    };

    public static WebPage of(String name) {
        WebPage webPage = new WebPage();
        webPage.setName(name);
        return webPage;
    }

    public static WebPage of(Supplier<String> nameSupplier) {
        WebPage webPage = new WebPage();
        webPage.setName(nameSupplier.get());
        return webPage;
    }

    public WebPage addImage(Image image) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(image);
        return this;
    }

    public WebPage addAlternateName(String language, String name) {
        if (this.alternateNames == null) {
            this.alternateNames = new HashMap<String, String>();
        }
        this.alternateNames.put(language, name);
        return this;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlternateNames(Map<String, String> alternateNames) {
        this.alternateNames = alternateNames;
    }

    public void setLastMod(Date lastMod) {
        this.lastMod = lastMod;
    }

    public void setChangeFreq(ChangeFreq changeFreq) {
        this.changeFreq = changeFreq;
    }

    public void setPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0.0 and 1.0");
        }
        this.priority = priority;
    }

    public String constructName() {
        String result = this.name;
        if (this.dir != null) {
            result = this.dir + "/" + result;
        }
        if (this.extension != null) {
            result = result + "." + this.extension;
        }
        return result;
    }

    public String constructShortName() {
        String result = this.shortName;
        if (this.dir != null) {
            result = this.dir + "/" + result;
        }
        if (this.extension != null) {
            result = result + "." + this.extension;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAlternateNames() {
        return this.alternateNames;
    }

    public Date getLastMod() {
        return this.lastMod;
    }

    public ChangeFreq getChangeFreq() {
        return this.changeFreq;
    }

    public Double getPriority() {
        return this.priority;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public int compareTo(WebPage o) {
        int result = PRIORITY_COMPARATOR.compare(this.getPriority(), o.getPriority());
        if (result == 0) {
            result = SHORT_NAME_COMPARATOR.compare(this.getShortName(), o.getShortName());
        }
        return result;
    }

    public static WebPageBuilder builder() {
        return new WebPageBuilder();
    }

    public static RssItemBuilder rssBuilder() {
        return new RssItemBuilder();
    }

    public static ImageBuilder imageBuilder() {
        return new ImageBuilder();
    }

    public static class ImageBuilder {
        private Image image = new Image();

        public ImageBuilder caption(String caption) {
            this.image.setCaption(caption);
            return this;
        }

        public ImageBuilder geoLocation(String geoLoation) {
            this.image.setGeoLocation(geoLoation);
            return this;
        }

        public ImageBuilder license(String license) {
            this.image.setLicense(license);
            return this;
        }

        public ImageBuilder loc(String loc) {
            this.image.setLoc(loc);
            return this;
        }

        public ImageBuilder title(String title) {
            this.image.setTitle(title);
            return this;
        }

        public Image build() {
            return this.image;
        }
    }

    public static class RssItemBuilder {
        private WebPage webPage = new WebPage();

        public RssItemBuilder pubDate(Date pubDate) {
            this.webPage.setLastMod(pubDate);
            return this;
        }

        public RssItemBuilder pubDate(LocalDateTime pubDate) {
            this.webPage.setLastMod(Timestamp.valueOf(pubDate));
            return this;
        }

        public RssItemBuilder title(String title) {
            this.webPage.setName(title);
            return this;
        }

        public RssItemBuilder titleCdata(String title) {
            this.webPage.setName("<![CDATA[ " + title + " ]]>");
            return this;
        }

        public RssItemBuilder description(String description) {
            this.webPage.setShortDescription(description);
            return this;
        }

        public RssItemBuilder descriptionCdata(String description) {
            this.webPage.setShortDescription("<![CDATA[ " + description + " ]]>");
            return this;
        }

        @Deprecated
        public RssItemBuilder name(String name) {
            this.webPage.setShortName(name);
            return this;
        }

        public RssItemBuilder link(String link) {
            this.webPage.setShortName(link);
            return this;
        }

        public RssItemBuilder name(String ... nameAndDirs) {
            this.webPage.setName(String.join((CharSequence)"/", nameAndDirs));
            return this;
        }

        public RssItemBuilder dir(String dirName) {
            this.webPage.setDir(dirName);
            return this;
        }

        public RssItemBuilder dir(String ... dirNames) {
            this.webPage.setDir(String.join((CharSequence)"/", dirNames));
            return this;
        }

        public RssItemBuilder extension(String extension) {
            this.webPage.setExtension(extension);
            return this;
        }

        public WebPage build() {
            return this.webPage;
        }
    }

    public static class WebPageBuilder {
        private WebPage webPage = new WebPage();

        public WebPageBuilder name(String name) {
            this.webPage.setName(name);
            return this;
        }

        public WebPageBuilder name(Supplier<String> supplier) {
            this.webPage.setName(supplier.get());
            return this;
        }

        public WebPageBuilder name(String ... nameAndDirs) {
            this.webPage.setName(String.join((CharSequence)"/", nameAndDirs));
            return this;
        }

        public WebPageBuilder alternateName(String language, String name) {
            this.webPage.addAlternateName(language, name);
            return this;
        }

        public WebPageBuilder alternateName(String language, Supplier<String> supplier) {
            this.webPage.addAlternateName(language, supplier.get());
            return this;
        }

        public WebPageBuilder dir(String dirName) {
            this.webPage.setDir(dirName);
            return this;
        }

        public WebPageBuilder dir(String ... dirNames) {
            this.webPage.setDir(String.join((CharSequence)"/", dirNames));
            return this;
        }

        public WebPageBuilder extension(String extension) {
            this.webPage.setExtension(extension);
            return this;
        }

        public WebPageBuilder nameRoot() {
            this.webPage.setName("");
            return this;
        }

        public WebPageBuilder maxPriorityRoot() {
            this.webPage.setName("");
            this.webPage.setPriority(1.0);
            return this;
        }

        public WebPageBuilder priority(Double priority) {
            this.webPage.setPriority(priority);
            return this;
        }

        public WebPageBuilder lastMod(Date lastMod) {
            this.webPage.setLastMod(lastMod);
            return this;
        }

        public WebPageBuilder lastMod(LocalDateTime lastMod) {
            this.webPage.setLastMod(Timestamp.valueOf(lastMod));
            return this;
        }

        public WebPageBuilder lastModNow() {
            this.webPage.setLastMod(new Date());
            return this;
        }

        public WebPageBuilder priorityMax() {
            this.webPage.setPriority(1.0);
            return this;
        }

        public WebPageBuilder changeFreq(ChangeFreq changeFreq) {
            this.webPage.setChangeFreq(changeFreq);
            return this;
        }

        public WebPageBuilder changeFreqAlways() {
            this.webPage.setChangeFreq(ChangeFreq.ALWAYS);
            return this;
        }

        public WebPageBuilder changeFreqHourly() {
            this.webPage.setChangeFreq(ChangeFreq.HOURLY);
            return this;
        }

        public WebPageBuilder changeFreqDaily() {
            this.webPage.setChangeFreq(ChangeFreq.DAILY);
            return this;
        }

        public WebPageBuilder changeFreqWeekly() {
            this.webPage.setChangeFreq(ChangeFreq.WEEKLY);
            return this;
        }

        public WebPageBuilder changeFreqMonthly() {
            this.webPage.setChangeFreq(ChangeFreq.MONTHLY);
            return this;
        }

        public WebPageBuilder changeFreqYearly() {
            this.webPage.setChangeFreq(ChangeFreq.YEARLY);
            return this;
        }

        public WebPageBuilder changeFreqNever() {
            this.webPage.setChangeFreq(ChangeFreq.NEVER);
            return this;
        }

        public WebPageBuilder images(List<Image> images) {
            this.webPage.setImages(images);
            return this;
        }

        public WebPage build() {
            return this.webPage;
        }
    }
}

