/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.robots;

import cz.jiripinkas.jsitemapgenerator.robots.RobotsRuleException;
import java.util.ArrayList;
import java.util.List;

public class RobotsRule {
    private String userAgent;
    private List<String> allows = new ArrayList<String>();
    private List<String> disallows = new ArrayList<String>();

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public List<String> getAllows() {
        return this.allows;
    }

    public void setAllows(List<String> allows) {
        this.allows = allows;
    }

    public List<String> getDisallows() {
        return this.disallows;
    }

    public void setDisallows(List<String> disallows) {
        this.disallows = disallows;
    }

    public static RobotsRuleBuilder builder() {
        return new RobotsRuleBuilder();
    }

    public static class RobotsRuleBuilder {
        private RobotsRule rule = new RobotsRule();

        public RobotsRuleBuilder userAgent(String userAgent) {
            this.rule.setUserAgent(userAgent);
            return this;
        }

        public RobotsRuleBuilder userAgentAll() {
            this.rule.setUserAgent("*");
            return this;
        }

        public RobotsRuleBuilder allows(List<String> allows) {
            this.rule.getAllows().addAll(allows);
            return this;
        }

        public RobotsRuleBuilder allow(String allow) {
            this.rule.getAllows().add(allow);
            return this;
        }

        public RobotsRuleBuilder allowAll() {
            this.rule.getAllows().add("/");
            return this;
        }

        public RobotsRuleBuilder disallows(List<String> disallows) {
            this.rule.getDisallows().addAll(disallows);
            return this;
        }

        public RobotsRuleBuilder disallow(String disallow) {
            this.rule.getDisallows().add(disallow);
            return this;
        }

        public RobotsRuleBuilder disallowAll() {
            this.rule.getDisallows().add("/");
            return this;
        }

        public RobotsRule build() {
            if (this.rule.getUserAgent() == null) {
                throw new RobotsRuleException("UserAgent is not specified!");
            }
            if (this.rule.getAllows().isEmpty() && this.rule.getDisallows().isEmpty()) {
                throw new RobotsRuleException("Either allows and / or disallows must be present!");
            }
            return this.rule;
        }
    }
}

