/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.robots;

import cz.jiripinkas.jsitemapgenerator.robots.RobotsRule;
import java.util.ArrayList;
import java.util.List;

public class RobotsTxtGenerator {
    private List<RobotsRule> rules = new ArrayList<RobotsRule>();
    private List<String> sitemaps = new ArrayList<String>();
    private String baseUrl;

    public static RobotsTxtGenerator of(String baseUrl) {
        RobotsTxtGenerator robotsTxtGenerator = new RobotsTxtGenerator();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        robotsTxtGenerator.setBaseUrl(baseUrl);
        return robotsTxtGenerator;
    }

    public String[] constructRobotsTxt() {
        ArrayList out = new ArrayList();
        this.sitemaps.forEach(sitemap -> out.add("Sitemap: " + this.baseUrl + sitemap));
        this.rules.forEach(rule -> {
            out.add("User-agent: " + rule.getUserAgent());
            rule.getAllows().forEach(allow -> out.add("Allow: " + allow));
            rule.getDisallows().forEach(disallow -> out.add("Disallow: " + disallow));
        });
        return out.toArray(new String[0]);
    }

    @Deprecated
    public String constructRobotsTxtString() {
        return this.toString();
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.constructRobotsTxt());
    }

    public RobotsTxtGenerator addSitemap(String sitemap) {
        this.sitemaps.add(sitemap);
        return this;
    }

    public RobotsTxtGenerator addRule(RobotsRule rule) {
        this.rules.add(rule);
        return this;
    }

    public List<RobotsRule> getRules() {
        return this.rules;
    }

    public void setRules(List<RobotsRule> rules) {
        this.rules = rules;
    }

    public List<String> getSitemaps() {
        return this.sitemaps;
    }

    public void setSitemaps(List<String> sitemaps) {
        this.sitemaps = sitemaps;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

