/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.HttpClient;
import cz.jiripinkas.jsitemapgenerator.UrlUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.GWTException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractSitemapGenerator<T extends AbstractGenerator>
extends AbstractGenerator<T> {
    protected W3CDateFormat dateFormat = new W3CDateFormat();
    private ChangeFreq defaultChangeFreq;
    private Double defaultPriority;
    private String defaultDir;
    private String defaultExtension;
    private Date defaultLastMod;
    private HttpClient httpClient = new HttpClient();

    public AbstractSitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    public abstract String[] toStringArray();

    @Deprecated
    public String constructSitemapString() {
        return this.toString();
    }

    public String toString() {
        String[] sitemapArray = this.toStringArray();
        StringBuilder result = new StringBuilder();
        for (String line : sitemapArray) {
            result.append(line);
        }
        return result.toString();
    }

    private ByteArrayOutputStream gzipIt(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (GZIPOutputStream gzos = new GZIPOutputStream(outputStream);
             InputStream in = inputStream;){
            int len;
            while ((len = in.read(buffer)) > 0) {
                gzos.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot perform gzip", ex);
        }
        return outputStream;
    }

    @Deprecated
    public byte[] constructSitemapGzip() {
        return this.toGzipByteArray();
    }

    public byte[] toGzipByteArray() {
        String sitemap = this.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sitemap.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream outputStream = this.gzipIt(inputStream);
        return outputStream.toByteArray();
    }

    @Deprecated
    public void saveSitemap(File file, String[] sitemap) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String string : sitemap) {
                writer.write(string);
            }
        }
    }

    public void toFile(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        String[] sitemap = this.toStringArray();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String string : sitemap) {
                writer.write(string);
            }
        }
    }

    public void toFile(Path path) throws IOException {
        this.toFile(path.toFile());
    }

    @Deprecated
    public void constructAndSaveSitemap(File file) throws IOException {
        this.toFile(file);
    }

    @Deprecated
    public void constructAndSaveSitemap(Path path) throws IOException {
        this.toFile(path);
    }

    public void pingGoogle(String sitemapUrl) {
        this.ping("https://www.google.com/ping?sitemap=", sitemapUrl, "Google");
    }

    public void pingBing(String sitemapUrl) {
        this.ping("http://www.bing.com/ping?sitemap=", sitemapUrl, "Bing");
    }

    private void ping(String resourceUrl, String sitemapUrl, String serviceName) {
        try {
            String pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
            int returnCode = this.httpClient.get(pingUrl);
            if (returnCode != 200) {
                throw new GWTException(serviceName + " could not be informed about new sitemap!");
            }
        }
        catch (Exception ex) {
            throw new GWTException(serviceName + " could not be informed about new sitemap!");
        }
    }

    public void pingGoogle() {
        this.pingGoogle(this.baseUrl + "sitemap.xml");
    }

    public void pingBing() {
        this.pingBing(this.baseUrl + "sitemap.xml");
    }

    @Override
    protected void beforeAddPageEvent(WebPage webPage) {
        if (this.defaultDir != null && webPage.getDir() == null) {
            webPage.setName(UrlUtil.connectUrlParts(this.defaultDir, webPage.constructName()));
        }
        if (this.defaultExtension != null && webPage.getExtension() == null) {
            webPage.setName(webPage.constructName() + "." + this.defaultExtension);
        }
        if (this.defaultPriority != null && webPage.getPriority() == null) {
            webPage.setPriority(this.defaultPriority);
        }
        if (this.defaultChangeFreq != null && webPage.getChangeFreq() == null) {
            webPage.setChangeFreq(this.defaultChangeFreq);
        }
        if (this.defaultLastMod != null && webPage.getLastMod() == null) {
            webPage.setLastMod(this.defaultLastMod);
        }
    }

    public T defaultDir(String dirName) {
        this.defaultDir = dirName;
        return (T)this.getThis();
    }

    public T defaultDir(String ... dirNames) {
        this.defaultDir = String.join((CharSequence)"/", dirNames);
        return (T)this.getThis();
    }

    public T resetDefaultDir() {
        this.defaultDir = null;
        return (T)this.getThis();
    }

    public T defaultExtension(String extension) {
        this.defaultExtension = extension;
        return (T)this.getThis();
    }

    public T resetDefaultExtension() {
        this.defaultExtension = null;
        return (T)this.getThis();
    }

    public T defaultPriorityMax() {
        this.defaultPriority = 1.0;
        return (T)this.getThis();
    }

    public T defaultPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0 and 1.0");
        }
        this.defaultPriority = priority;
        return (T)this.getThis();
    }

    public T resetDefaultPriority() {
        this.defaultPriority = null;
        return (T)this.getThis();
    }

    public T defaultChangeFreq(ChangeFreq changeFreq) {
        this.defaultChangeFreq = changeFreq;
        return (T)this.getThis();
    }

    public T defaultChangeFreqAlways() {
        this.defaultChangeFreq = ChangeFreq.ALWAYS;
        return (T)this.getThis();
    }

    public T defaultChangeFreqHourly() {
        this.defaultChangeFreq = ChangeFreq.HOURLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqDaily() {
        this.defaultChangeFreq = ChangeFreq.DAILY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqWeekly() {
        this.defaultChangeFreq = ChangeFreq.WEEKLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqMonthly() {
        this.defaultChangeFreq = ChangeFreq.MONTHLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqYearly() {
        this.defaultChangeFreq = ChangeFreq.YEARLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqNever() {
        this.defaultChangeFreq = ChangeFreq.NEVER;
        return (T)this.getThis();
    }

    public T resetDefaultChangeFreq() {
        this.defaultChangeFreq = null;
        return (T)this.getThis();
    }

    public T defaultLastMod(Date lastMod) {
        this.defaultLastMod = lastMod;
        return (T)this.getThis();
    }

    public T defaultLastMod(LocalDateTime lastMod) {
        this.defaultLastMod = Timestamp.valueOf(lastMod);
        return (T)this.getThis();
    }

    public T defaultLastModNow() {
        this.defaultLastMod = new Date();
        return (T)this.getThis();
    }

    public T resetDefaultLastMod() {
        this.defaultLastMod = null;
        return (T)this.getThis();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected String getAbsoluteUrl(String webPageName) {
        webPageName = UrlUtil.escapeXmlSpecialCharacters(webPageName);
        try {
            String resultString;
            if (webPageName != null) {
                URI uri = new URI(webPageName);
                String stringUrl = uri.isAbsolute() ? webPageName : UrlUtil.connectUrlParts(this.baseUrl, webPageName);
                resultString = stringUrl;
            } else {
                resultString = this.baseUrl;
            }
            return new URL(resultString).toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidUrlException(e);
        }
    }
}

