/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public abstract class AbstractGenerator {
    protected Map<String, WebPage> urls = new TreeMap<String, WebPage>();
    protected String baseUrl;

    public AbstractGenerator(String baseUrl, boolean root) {
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        if (root && !baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public AbstractGenerator(String baseUrl) {
        this(baseUrl, true);
    }

    public AbstractGenerator addPage(WebPage webPage) {
        this.urls.put(this.baseUrl + webPage.getName(), webPage);
        return this;
    }

    public AbstractGenerator addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
        return this;
    }

    public <T> AbstractGenerator addPages(Collection<T> webPages, Function<T, WebPage> mapper) {
        for (T element : webPages) {
            this.addPage(mapper.apply(element));
        }
        return this;
    }
}

