/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractSitemapGenerator;
import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.Image;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public class SitemapGenerator
extends AbstractSitemapGenerator {
    private StringBuilder additionalNamespacesStringBuilder = new StringBuilder();
    private ChangeFreq defaultChangeFreq;
    private Double defaultPriority;
    private String dir;
    private String extension;

    @Deprecated
    public SitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    @Deprecated
    public SitemapGenerator(String baseUrl, AdditionalNamespace[] additionalNamespaces) {
        this(baseUrl);
        if (Arrays.asList(additionalNamespaces).contains((Object)AdditionalNamespace.IMAGE)) {
            this.additionalNamespacesStringBuilder.append(" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" ");
        }
    }

    public static SitemapGenerator of(String baseUrl) {
        return new SitemapGenerator(baseUrl);
    }

    public static SitemapGenerator of(String baseUrl, AdditionalNamespace[] additionalNamespaces) {
        return new SitemapGenerator(baseUrl, additionalNamespaces);
    }

    @Override
    public String[] constructSitemap() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.add("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"" + this.additionalNamespacesStringBuilder.toString() + ">\n");
        ArrayList values = new ArrayList(this.urls.values());
        Collections.sort(values);
        for (WebPage webPage : values) {
            out.add("<url>\n");
            if (this.dir != null) {
                webPage.setName(this.dir + "/" + webPage.getName());
            }
            if (this.extension != null) {
                webPage.setName(webPage.getName() + "." + this.extension);
            }
            if (this.defaultPriority != null && webPage.getPriority() == null) {
                webPage.setPriority(this.defaultPriority);
            }
            if (this.defaultChangeFreq != null && webPage.getChangeFreq() == null) {
                webPage.setChangeFreq(this.defaultChangeFreq);
            }
            out.add(this.constructUrl(webPage));
            if (webPage.getImages() != null) {
                for (Image image : webPage.getImages()) {
                    out.add(this.constructImage(image));
                }
            }
            out.add("</url>\n");
        }
        out.add("</urlset>");
        return out.toArray(new String[0]);
    }

    String constructImage(Image image) {
        StringBuilder out = new StringBuilder();
        out.append("<image:image>\n");
        if (image.getLoc() != null) {
            out.append("<image:loc>");
            out.append(image.getLoc());
            out.append("</image:loc>\n");
        }
        if (image.getCaption() != null) {
            out.append("<image:caption>");
            out.append(image.getCaption());
            out.append("</image:caption>\n");
        }
        if (image.getGeoLocation() != null) {
            out.append("<image:geo_location>");
            out.append(image.getGeoLocation());
            out.append("</image:geo_location>\n");
        }
        if (image.getTitle() != null) {
            out.append("<image:title>");
            out.append(image.getTitle());
            out.append("</image:title>\n");
        }
        if (image.getLicense() != null) {
            out.append("<image:license>");
            out.append(image.getLicense());
            out.append("</image:license>\n");
        }
        out.append("</image:image>\n");
        return out.toString();
    }

    String constructUrl(WebPage webPage) {
        StringBuilder out = new StringBuilder();
        out.append("<loc>");
        try {
            if (webPage.getName() != null) {
                String wpName = webPage.getName();
                if (this.baseUrl.endsWith("/")) {
                    while (wpName.startsWith("/")) {
                        wpName = wpName.substring(1);
                    }
                }
                out.append(this.escapeXmlSpecialCharacters(new URL(this.baseUrl + wpName).toString()));
            } else {
                out.append(this.escapeXmlSpecialCharacters(new URL(this.baseUrl).toString()));
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        out.append("</loc>\n");
        if (webPage.getLastMod() != null) {
            out.append("<lastmod>");
            out.append(this.dateFormat.format(webPage.getLastMod()));
            out.append("</lastmod>\n");
        }
        if (webPage.getChangeFreq() != null) {
            out.append("<changefreq>");
            out.append((Object)webPage.getChangeFreq());
            out.append("</changefreq>\n");
        }
        if (webPage.getPriority() != null) {
            out.append("<priority>");
            out.append(webPage.getPriority());
            out.append("</priority>\n");
        }
        return out.toString();
    }

    @Override
    public SitemapGenerator addPage(WebPage webPage) {
        this.urls.put(this.baseUrl + webPage.getName(), webPage);
        return this;
    }

    @Override
    public SitemapGenerator addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
        return this;
    }

    @Override
    public <T> SitemapGenerator addPages(Collection<T> webPages, Function<T, WebPage> mapper) {
        for (T element : webPages) {
            this.addPage(mapper.apply(element));
        }
        return this;
    }

    public SitemapGenerator dir(String dirName) {
        this.dir = dirName;
        return this;
    }

    public SitemapGenerator dir(String ... dirNames) {
        this.dir = String.join((CharSequence)"/", dirNames);
        return this;
    }

    public SitemapGenerator extension(String extension) {
        this.extension = extension;
        return this;
    }

    public SitemapGenerator defaultPriorityMax() {
        this.defaultPriority = 1.0;
        return this;
    }

    public void setDefaultPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0 and 1.0");
        }
        this.defaultPriority = priority;
    }

    public SitemapGenerator defaultChangeFreq(ChangeFreq changeFreq) {
        this.defaultChangeFreq = changeFreq;
        return this;
    }

    public SitemapGenerator defaultChangeFreqAlways() {
        this.defaultChangeFreq = ChangeFreq.ALWAYS;
        return this;
    }

    public SitemapGenerator defaultChangeFreqHourly() {
        this.defaultChangeFreq = ChangeFreq.HOURLY;
        return this;
    }

    public SitemapGenerator defaultChangeFreqDaily() {
        this.defaultChangeFreq = ChangeFreq.DAILY;
        return this;
    }

    public SitemapGenerator defaultChangeFreqWeekly() {
        this.defaultChangeFreq = ChangeFreq.WEEKLY;
        return this;
    }

    public SitemapGenerator defaultChangeFreqMonthly() {
        this.defaultChangeFreq = ChangeFreq.MONTHLY;
        return this;
    }

    public SitemapGenerator defaultChangeFreqYearly() {
        this.defaultChangeFreq = ChangeFreq.YEARLY;
        return this;
    }

    public SitemapGenerator defaultChangeFreqNever() {
        this.defaultChangeFreq = ChangeFreq.NEVER;
        return this;
    }

    public static enum AdditionalNamespace {
        IMAGE;

    }
}

