/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class RssGenerator
extends AbstractGenerator<RssGenerator> {
    private static final String DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss";
    private String webTitle;
    private String webDescription;

    @Deprecated
    public RssGenerator(String baseUrl, boolean root, String webTitle, String webDescription) {
        super(baseUrl, root);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    @Deprecated
    public RssGenerator(String baseUrl, String webTitle, String webDescription) {
        super(baseUrl);
        this.webTitle = webTitle;
        this.webDescription = webDescription;
    }

    public static RssGenerator of(String baseUrl, boolean root, String webTitle, String webDescription) {
        return new RssGenerator(baseUrl, root, webTitle, webDescription);
    }

    public static RssGenerator of(String baseUrl, boolean root) {
        return new RssGenerator(baseUrl, root, null, null);
    }

    public static RssGenerator of(String baseUrl, String webTitle, String webDescription) {
        return new RssGenerator(baseUrl, webTitle, webDescription);
    }

    public static RssGenerator of(String baseUrl) {
        return new RssGenerator(baseUrl, null, null);
    }

    public RssGenerator webTitle(String webTitle) {
        this.webTitle = webTitle;
        return this;
    }

    public RssGenerator webDescription(String webDescription) {
        this.webDescription = webDescription;
        return this;
    }

    public String constructRss() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        builder.append("<rss version=\"2.0\">\n");
        builder.append("<channel>\n");
        builder.append("<title>" + this.webTitle + "</title>\n");
        builder.append("<link>" + this.baseUrl + "</link>\n");
        builder.append("<description>" + this.webDescription + "</description>\n");
        ArrayList webPages = new ArrayList(this.urls.values());
        webPages.sort(Comparator.comparing(WebPage::getLastMod).reversed());
        Date latestDate = new Date();
        if (!webPages.isEmpty()) {
            latestDate = ((WebPage)webPages.get(0)).getLastMod();
        }
        builder.append("<pubDate>" + new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate) + " +0000</pubDate>\n");
        builder.append("<lastBuildDate>" + new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(latestDate) + " +0000</lastBuildDate>\n");
        builder.append("<ttl>1800</ttl>\n");
        for (WebPage webPage : webPages) {
            builder.append("<item>\n");
            builder.append("<title>");
            builder.append(webPage.constructName());
            builder.append("</title>\n");
            builder.append("<description>");
            builder.append(webPage.getShortDescription());
            builder.append("</description>\n");
            builder.append("<link>");
            builder.append(this.baseUrl + webPage.getShortName());
            builder.append("</link>\n");
            builder.append("<pubDate>");
            builder.append(new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH).format(webPage.getLastMod()) + " +0000");
            builder.append("</pubDate>\n");
            builder.append("</item>\n");
        }
        builder.append("</channel>\n");
        builder.append("</rss>\n");
        return builder.toString();
    }
}

