/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractSitemapGenerator;
import cz.jiripinkas.jsitemapgenerator.Image;
import cz.jiripinkas.jsitemapgenerator.UrlUtil;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SitemapGenerator
extends AbstractSitemapGenerator<SitemapGenerator> {
    private SitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    private String constructAdditionalNamespacesString(List<AdditionalNamespace> additionalNamespaceList) {
        String result = "";
        if (additionalNamespaceList.contains((Object)AdditionalNamespace.IMAGE)) {
            result = result + " xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" ";
        }
        if (additionalNamespaceList.contains((Object)AdditionalNamespace.XHTML)) {
            result = result + " xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" ";
        }
        return result;
    }

    public static SitemapGenerator of(String baseUrl) {
        return new SitemapGenerator(baseUrl);
    }

    @Override
    public String[] toStringArray() {
        boolean hasAlternateNames;
        ArrayList<AdditionalNamespace> additionalNamespaces = new ArrayList<AdditionalNamespace>();
        boolean hasImages = this.urls.values().stream().anyMatch(webPage -> webPage.getImages() != null);
        if (hasImages) {
            additionalNamespaces.add(AdditionalNamespace.IMAGE);
        }
        if (hasAlternateNames = this.urls.values().stream().anyMatch(webPage -> webPage.getAlternateNames() != null)) {
            additionalNamespaces.add(AdditionalNamespace.XHTML);
        }
        ArrayList<String> out = new ArrayList<String>();
        out.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.add("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"" + this.constructAdditionalNamespacesString(additionalNamespaces) + ">\n");
        ArrayList values = new ArrayList(this.urls.values());
        Collections.sort(values);
        for (WebPage webPage2 : values) {
            out.add("<url>\n");
            out.add(this.constructUrl(webPage2));
            if (webPage2.getImages() != null) {
                for (Image image : webPage2.getImages()) {
                    out.add(this.constructImage(image));
                }
            }
            out.add("</url>\n");
        }
        out.add("</urlset>");
        return out.toArray(new String[0]);
    }

    protected String constructImage(Image image) {
        StringBuilder out = new StringBuilder();
        out.append("<image:image>\n");
        if (image.getLoc() != null) {
            out.append("<image:loc>");
            out.append(this.getAbsoluteUrl(image.getLoc()));
            out.append("</image:loc>\n");
        }
        if (image.getCaption() != null) {
            out.append("<image:caption>");
            out.append(UrlUtil.escapeXmlSpecialCharacters(image.getCaption()));
            out.append("</image:caption>\n");
        }
        if (image.getGeoLocation() != null) {
            out.append("<image:geo_location>");
            out.append(UrlUtil.escapeXmlSpecialCharacters(image.getGeoLocation()));
            out.append("</image:geo_location>\n");
        }
        if (image.getTitle() != null) {
            out.append("<image:title>");
            out.append(UrlUtil.escapeXmlSpecialCharacters(image.getTitle()));
            out.append("</image:title>\n");
        }
        if (image.getLicense() != null) {
            out.append("<image:license>");
            out.append(UrlUtil.escapeXmlSpecialCharacters(image.getLicense()));
            out.append("</image:license>\n");
        }
        out.append("</image:image>\n");
        return out.toString();
    }

    protected String constructUrl(WebPage webPage) {
        StringBuilder out = new StringBuilder();
        out.append("<loc>");
        out.append(this.getAbsoluteUrl(webPage.constructName()));
        out.append("</loc>\n");
        if (webPage.getAlternateNames() != null) {
            for (Map.Entry<String, String> entry : webPage.getAlternateNames().entrySet()) {
                out.append("<xhtml:link rel=\"alternate\" hreflang=\"");
                out.append(UrlUtil.escapeXmlSpecialCharacters(entry.getKey()));
                out.append("\" href=\"");
                out.append(this.getAbsoluteUrl(entry.getValue()));
                out.append("\"/>\n");
            }
        }
        if (webPage.getLastMod() != null) {
            out.append("<lastmod>");
            out.append(this.dateFormat.format(webPage.getLastMod()));
            out.append("</lastmod>\n");
        }
        if (webPage.getChangeFreq() != null) {
            out.append("<changefreq>");
            out.append((Object)webPage.getChangeFreq());
            out.append("</changefreq>\n");
        }
        if (webPage.getPriority() != null) {
            out.append("<priority>");
            out.append(webPage.getPriority());
            out.append("</priority>\n");
        }
        return out.toString();
    }

    public static enum AdditionalNamespace {
        IMAGE,
        XHTML;

    }
}

