/* Generated By:JavaCC: Do not edit this line. RSQLParser.java */
package cz.jirutka.rsql.parser;

import cz.jirutka.rsql.parser.model.Comparison;
import cz.jirutka.rsql.parser.model.ComparisonExpression;
import cz.jirutka.rsql.parser.model.Expression;
import cz.jirutka.rsql.parser.model.Logical;
import cz.jirutka.rsql.parser.model.LogicalExpression;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <b>Parser of RSQL (RESTful Service Query Language)</b>
 *
 * <p>RSQL is a language designed for searching entries in RESTful services. 
 * It's based on URI-friendly syntax 
 * <a href="http://tools.ietf.org/html/draft-nottingham-atompub-fiql-00">
 * FIQL</a> (Feed Item Query Language), so it can be used for parsing FIQL 
 * as well.</p>
 *
 * <p><b>Grammar</b>
 * 
 * <pre>{@code
 *  expression           = [ "(" ],
 *                        ( constraint | expression ),
 *                        [ logical-operator, ( constraint | expression ) ],
 *                        [ ")" ];
 * constraint           = selector, comparison-operator, argument;
 *
 * logical-operator     = ";" | " and " | "," | " or ";
 * comparison-operator  = "==" | "=" | "!=" | "=lt=" | "<" | "=le=" | "<=" | 
 *                        "=gt=" | ">" | "=ge=" | ">=";
 *
 * selector             = qname, { ("/" | "."), qname };
 * qname                = identifier, [ ":", identifier ];
 * identifier           = ? ["a"-"z","A"-"Z","_","0"-"9","-"]+ ?
 *
 * argument             = arg_ws | arg_sq | arg_dq;
 * argument-ws          = ? ( ~["(", ")", ";", ",", " "] )+ ?;
 * argument-sq          = ? "'" ~["'"]+ "'" ?;
 * argument-dq          = ? "\"" ~["\""]+ "\"" ?;
 * }</pre></p>
 *
 * <b>Semantics</b>
 * <p>Logical operators:
 * <ul>
 *   <li>Logical AND : ";" or " and "</li>
 *   <li>Logical OR : "," or " or "</li>
 * </ul></p>
 *
 * <p>Comparison operators:
 * <ul>
 *   <li>Equal to : "==" or "="
 *   <li>Not equal to : "!="
 *   <li>Less than : "=lt=" or "<"
 *   <li>Less than or equal to : "=le=" or "<="
 *   <li>Greater than operator : "=gt=" or ">"
 *   <li>Greater than or equal to: "=ge=" or ">="
 * </ul></p>
 *
 * <p>Generated by JavaCC 5.0</p>
 *
 * @version 1.0
 * @author Jakub Jirutka <jakub@jirutka.cz>
 */
public class RSQLParser implements RSQLParserConstants {

    private static final Logger LOG = LoggerFactory.getLogger(RSQLParser.class);
    public static final String ENCODING = "UTF-8";

    /** 
     * Parse given query expression and build query tree. 
     *
     * @param expression
     * @return query tree
     */
    public static Expression parse(String expression) throws ParseException, TokenMgrError {
        InputStream input;
        try {
            input = new ByteArrayInputStream(expression.getBytes(ENCODING));
        } catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }

        RSQLParser parser = new RSQLParser(input, ENCODING);

        if (!LOG.isTraceEnabled()) {
            parser.disable_tracing();
        }

        return parser.input();
    }

/** {@code input -> disjunction } */
  final public Expression input() throws ParseException {
    trace_call("input");
    try {
    final Expression exp;
      exp = disjunction();
      jj_consume_token(0);
        {if (true) return exp;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("input");
    }
  }

/** {@code disjunction -> conjunction ( <OR> disjunction )? } */
  final public Expression disjunction() throws ParseException {
    trace_call("disjunction");
    try {
    Expression left = null;
    Expression right = null;
      left = conjunction();

      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        jj_consume_token(OR);
        right = disjunction();

        break;
      default:
        jj_la1[0] = jj_gen;
        ;
      }
        if (right == null) {
            {if (true) return left;}
        } else {
            {if (true) return new LogicalExpression(left, Logical.OR, right);}
        }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("disjunction");
    }
  }

/** {@code conjunction -> constraint ( <AND> conjunction )? } */
  final public Expression conjunction() throws ParseException {
    trace_call("conjunction");
    try {
    Expression left = null;
    Expression right = null;
      left = constraint();

      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        jj_consume_token(AND);
        right = conjunction();

        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
        if (right == null) {
            {if (true) return left;}
        } else {
            {if (true) return new LogicalExpression(left, Logical.AND, right);}
        }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("conjunction");
    }
  }

/** 
 * {@code constraint -> <SELECTOR> <COMPARISON> <ARGUMENT> 
 *                      | <LPAREN> disjunction <RPAREN> } 
 */
  final public Expression constraint() throws ParseException {
    trace_call("constraint");
    try {
    final String sel;
    final Comparison op;
    final String arg;
    final Expression exp;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECTOR:
        sel = selector();
        op = comparison();
        arg = argument();
        {if (true) return new ComparisonExpression(sel, op, arg);}
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        exp = disjunction();
        jj_consume_token(RPAREN);
        {if (true) return exp;}
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("constraint");
    }
  }

/** 
 * {@code 
 * <COMPARISON> : ("=="|"=lt="|"=le="|"=gt="|"=ge="|"="|"!="|"<"|"<="|">"|">=") 
 * }
 */
  final public Comparison comparison() throws ParseException {
    trace_call("comparison");
    try {
    final Token t;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case LE:
        t = jj_consume_token(LE);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        switch (t.kind) {
            case RSQLParserConstants.EQ : {if (true) return Comparison.EQUAL;}
            case RSQLParserConstants.NE : {if (true) return Comparison.NOT_EQUAL;}
            case RSQLParserConstants.GT : {if (true) return Comparison.GREATER_THAN;}
            case RSQLParserConstants.GE : {if (true) return Comparison.GREATER_EQUAL;}
            case RSQLParserConstants.LT : {if (true) return Comparison.LESS_THAN;}
            case RSQLParserConstants.LE : {if (true) return Comparison.LESS_EQUAL;}
            default : {if (true) throw new ParseException("Missing comparison operator in enum Comparison");}
        }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("comparison");
    }
  }

/** 
 * <pre>{@code
 * <SELECTOR> : <#QNAME> ( ["/","."] <#QNAME> )*
 *   <#QNAME> : <#IDENTIFIER> (":" <#IDENTIFIER> )?
 *   <#IDENTIFIER> : ( ["a"-"z","A"-"Z","_","0"-"9","-"] )+ 
 * }</pre> 
 */
  final public String selector() throws ParseException {
    trace_call("selector");
    try {
    final Token t;
      t = jj_consume_token(SELECTOR);
        {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("selector");
    }
  }

/** 
 * {@code
 * <ARGUMENT> : (~["(",")",";",","," "])+ | ("'"(~["'"])+"'") | ("\""(~["\""] )+"\"") 
 * }
 */
  final public String argument() throws ParseException {
    trace_call("argument");
    try {
    final Token t;
      t = jj_consume_token(ARGUMENT);
        if (t.image.startsWith("\u005c"") || t.image.startsWith("'")) {
            //remove quotes
            {if (true) return t.image.substring(1, t.image.length() -1);}
        }
        {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("argument");
    }
  }

  /** Generated Token Manager. */
  public RSQLParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[4];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x10,0x8,0x802,0x7e0,};
   }

  /** Constructor with InputStream. */
  public RSQLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public RSQLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new RSQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public RSQLParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RSQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public RSQLParser(RSQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(RSQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      trace_token(token, "");
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
      trace_token(token, " (in getNextToken)");
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[15];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 4; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 15; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled = true;

/** Enable tracing. */
  final public void enable_tracing() {
    trace_enabled = true;
  }

/** Disable tracing. */
  final public void disable_tracing() {
    trace_enabled = false;
  }

  private void trace_call(String s) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Call:   " + s);
    }
    trace_indent = trace_indent + 2;
  }

  private void trace_return(String s) {
    trace_indent = trace_indent - 2;
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Return: " + s);
    }
  }

  private void trace_token(Token t, String where) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Consumed token: <" + tokenImage[t.kind]);
      if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
        System.out.print(": \"" + t.image + "\"");
      }
      System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
    }
  }

  private void trace_scan(Token t1, int t2) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Visited token: <" + tokenImage[t1.kind]);
      if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
        System.out.print(": \"" + t1.image + "\"");
      }
      System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
    }
  }

}
