/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser;

import cz.jirutka.rsql.parser.ParseException;
import cz.jirutka.rsql.parser.RSQLParserConstants;
import cz.jirutka.rsql.parser.RSQLParserTokenManager;
import cz.jirutka.rsql.parser.SimpleCharStream;
import cz.jirutka.rsql.parser.Token;
import cz.jirutka.rsql.parser.TokenMgrError;
import cz.jirutka.rsql.parser.model.Comparison;
import cz.jirutka.rsql.parser.model.ComparisonExpression;
import cz.jirutka.rsql.parser.model.Expression;
import cz.jirutka.rsql.parser.model.Logical;
import cz.jirutka.rsql.parser.model.LogicalExpression;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSQLParser
implements RSQLParserConstants {
    private static final Logger LOG = LoggerFactory.getLogger(RSQLParser.class);
    public static final String ENCODING = "UTF-8";
    public RSQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[4];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int trace_indent = 0;
    private boolean trace_enabled = true;

    public static Expression parse(String expression) throws ParseException, TokenMgrError {
        ByteArrayInputStream input;
        try {
            input = new ByteArrayInputStream(expression.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
        RSQLParser parser = new RSQLParser(input, ENCODING);
        if (!LOG.isTraceEnabled()) {
            parser.disable_tracing();
        }
        return parser.input();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression input() throws ParseException {
        this.trace_call("input");
        try {
            Expression exp = this.disjunction();
            this.jj_consume_token(0);
            Expression expression = exp;
            return expression;
        }
        finally {
            this.trace_return("input");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression disjunction() throws ParseException {
        this.trace_call("disjunction");
        try {
            Expression left = null;
            Expression right = null;
            left = this.conjunction();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    right = this.disjunction();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            if (right == null) {
                Expression expression = left;
                return expression;
            }
            LogicalExpression logicalExpression = new LogicalExpression(left, Logical.OR, right);
            return logicalExpression;
        }
        finally {
            this.trace_return("disjunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression conjunction() throws ParseException {
        this.trace_call("conjunction");
        try {
            Expression left = null;
            Expression right = null;
            left = this.constraint();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    right = this.conjunction();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            if (right == null) {
                Expression expression = left;
                return expression;
            }
            LogicalExpression logicalExpression = new LogicalExpression(left, Logical.AND, right);
            return logicalExpression;
        }
        finally {
            this.trace_return("conjunction");
        }
    }

    public final Expression constraint() throws ParseException {
        this.trace_call("constraint");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    String sel = this.selector();
                    Comparison op = this.comparison();
                    String arg = this.argument();
                    ComparisonExpression comparisonExpression = new ComparisonExpression(sel, op, arg);
                    return comparisonExpression;
                }
                case 1: {
                    this.jj_consume_token(1);
                    Expression exp = this.disjunction();
                    this.jj_consume_token(2);
                    Expression expression = exp;
                    return expression;
                }
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("constraint");
        }
    }

    public final Comparison comparison() throws ParseException {
        this.trace_call("comparison");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    t = this.jj_consume_token(5);
                    break;
                }
                case 6: {
                    t = this.jj_consume_token(6);
                    break;
                }
                case 7: {
                    t = this.jj_consume_token(7);
                    break;
                }
                case 8: {
                    t = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    t = this.jj_consume_token(9);
                    break;
                }
                case 10: {
                    t = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (t.kind) {
                case 5: {
                    Comparison comparison = Comparison.EQUAL;
                    return comparison;
                }
                case 8: {
                    Comparison comparison = Comparison.NOT_EQUAL;
                    return comparison;
                }
                case 6: {
                    Comparison comparison = Comparison.GREATER_THAN;
                    return comparison;
                }
                case 9: {
                    Comparison comparison = Comparison.GREATER_EQUAL;
                    return comparison;
                }
                case 7: {
                    Comparison comparison = Comparison.LESS_THAN;
                    return comparison;
                }
                case 10: {
                    Comparison comparison = Comparison.LESS_EQUAL;
                    return comparison;
                }
            }
            throw new ParseException("Missing comparison operator in enum Comparison");
        }
        finally {
            this.trace_return("comparison");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String selector() throws ParseException {
        this.trace_call("selector");
        try {
            Token t = this.jj_consume_token(11);
            String string = t.image;
            return string;
        }
        finally {
            this.trace_return("selector");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String argument() throws ParseException {
        this.trace_call("argument");
        try {
            Token t = this.jj_consume_token(14);
            if (t.image.startsWith("\"") || t.image.startsWith("'")) {
                String string = t.image.substring(1, t.image.length() - 1);
                return string;
            }
            String string = t.image;
            return string;
        }
        finally {
            this.trace_return("argument");
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{16, 8, 2050, 2016};
    }

    public RSQLParser(InputStream stream) {
        this(stream, null);
    }

    public RSQLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new RSQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public RSQLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RSQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public RSQLParser(RSQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(RSQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[15];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 4; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 15; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    private void trace_call(String s) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Call:   " + s);
        }
        this.trace_indent += 2;
    }

    private void trace_return(String s) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Return: " + s);
        }
    }

    private void trace_token(Token t, String where) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Consumed token: <" + tokenImage[t.kind]);
            if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
                System.out.print(": \"" + t.image + "\"");
            }
            System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
        }
    }

    private void trace_scan(Token t1, int t2) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Visited token: <" + tokenImage[t1.kind]);
            if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
                System.out.print(": \"" + t1.image + "\"");
            }
            System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
        }
    }

    static {
        RSQLParser.jj_la1_init_0();
    }
}

