/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser;

import cz.jirutka.rsql.parser.ParseException;
import cz.jirutka.rsql.parser.Parser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.TokenMgrError;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLNodesFactory;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;

public final class RSQLParser {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private final RSQLNodesFactory nodesFactory;

    public RSQLParser() {
        this.nodesFactory = new RSQLNodesFactory();
    }

    public RSQLParser(RSQLNodesFactory nodesFactory) {
        if (nodesFactory == null) {
            throw new IllegalArgumentException("nodesFactory must not be null");
        }
        this.nodesFactory = nodesFactory;
    }

    public Node parse(String query) throws RSQLParserException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes(ENCODING));
        Parser parser = new Parser(is, ENCODING.name(), this.nodesFactory);
        try {
            return parser.Input();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new RSQLParserException(ex);
        }
    }
}

