/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.AbstractNode;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class ComparisonNode
extends AbstractNode {
    private final String selector;
    private final List<String> arguments;

    protected ComparisonNode(String selector, List<String> arguments) {
        assert (StringUtils.isNotBlank(selector)) : "selector must not be blank";
        assert (arguments.size() > 0) : "arguments list must not be empty";
        this.selector = selector;
        this.arguments = arguments;
    }

    public abstract String getOperator();

    public String getSelector() {
        return this.selector;
    }

    public List<String> getArguments() {
        return new ArrayList<String>(this.arguments);
    }

    public String toString() {
        String args = this.arguments.size() > 1 ? "('" + StringUtils.join(this.arguments, "','") + "')" : "'" + this.arguments.get(0) + "'";
        return String.valueOf(this.selector) + this.getOperator() + args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonNode)) {
            return false;
        }
        ComparisonNode that = (ComparisonNode)o;
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        if (!this.getOperator().equals(this.getOperator())) {
            return false;
        }
        return this.selector.equals(that.selector);
    }

    public int hashCode() {
        int result = this.selector.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.getOperator().hashCode();
        return result;
    }
}

