/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.AbstractNode;
import cz.jirutka.rsql.parser.ast.LogicalOp;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class LogicalNode
extends AbstractNode
implements Iterable<Node> {
    private final List<Node> children = new ArrayList<Node>();
    private final LogicalOp operator;

    protected LogicalNode(LogicalOp operator, List<? extends Node> children) {
        assert (operator != null) : "operator must not be null";
        assert (children != null) : "children must not be null";
        this.operator = operator;
        this.children.addAll(children);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public LogicalOp getOperator() {
        return this.operator;
    }

    public String toString() {
        return "(" + StringUtils.join(this.children, this.operator.toString()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogicalNode)) {
            return false;
        }
        LogicalNode nodes = (LogicalNode)o;
        if (!this.children.equals(nodes.children)) {
            return false;
        }
        return this.operator == nodes.operator;
    }

    public int hashCode() {
        int result = this.children.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }
}

