/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.UnknownOperatorException;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOp;
import cz.jirutka.rsql.parser.ast.EqualNode;
import cz.jirutka.rsql.parser.ast.GreaterThanNode;
import cz.jirutka.rsql.parser.ast.GreaterThanOrEqualNode;
import cz.jirutka.rsql.parser.ast.InNode;
import cz.jirutka.rsql.parser.ast.LessThanNode;
import cz.jirutka.rsql.parser.ast.LessThanOrEqualNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.LogicalOp;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.NotEqualNode;
import cz.jirutka.rsql.parser.ast.NotInNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import java.util.Arrays;
import java.util.List;

public class RSQLNodesFactory {
    public LogicalNode createLogicalNode(LogicalOp operator, List<Node> children) {
        switch (operator) {
            case AND: {
                return new AndNode(children);
            }
            case OR: {
                return new OrNode(children);
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)operator));
    }

    public ComparisonNode createComparisonNode(String operator, String selector, String argument) throws UnknownOperatorException {
        return this.createComparisonNode(operator, selector, Arrays.asList(argument));
    }

    public ComparisonNode createComparisonNode(String operator, String selector, List<String> arguments) throws UnknownOperatorException {
        switch (ComparisonOp.parse(operator)) {
            case EQ: {
                return new EqualNode(selector, arguments);
            }
            case IN: {
                return new InNode(selector, arguments);
            }
            case GE: {
                return new GreaterThanOrEqualNode(selector, arguments);
            }
            case GT: {
                return new GreaterThanNode(selector, arguments);
            }
            case LE: {
                return new LessThanOrEqualNode(selector, arguments);
            }
            case LT: {
                return new LessThanNode(selector, arguments);
            }
            case NE: {
                return new NotEqualNode(selector, arguments);
            }
            case OUT: {
                return new NotInNode(selector, arguments);
            }
        }
        throw new UnknownOperatorException("Unknown operator: " + operator);
    }
}

