/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.embedmongo;

import com.mongodb.Mongo;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jLevel;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jProgressListener;
import cz.jirutka.spring.embedmongo.slf4j.Slf4jStreamProcessor;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.mongo.config.ArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class EmbeddedMongoFactoryBean
implements FactoryBean<Mongo> {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedMongoFactoryBean.class);
    private String version;
    private Integer port;
    private String bindIp = "localhost";

    public Mongo getObject() throws Exception {
        LOG.info("Initializing embedded MongoDB instance");
        MongodStarter runtime = MongodStarter.getInstance((IRuntimeConfig)this.buildRuntimeConfig());
        MongodExecutable mongodExe = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)this.buildMongodConfig());
        LOG.info("Starting embedded MongoDB instance");
        mongodExe.start();
        return new Mongo(this.getBindIp(), this.getPort());
    }

    public Class<Mongo> getObjectType() {
        return Mongo.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setPort(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port number must be between 0 and 65535");
        }
        this.port = port;
    }

    public int getPort() {
        if (this.port == null) {
            try {
                this.port = Network.getFreeServerPort();
            }
            catch (IOException ex) {
                LOG.error("Could not get free server port");
            }
        }
        return this.port;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    private ProcessOutput buildOutputConfig() {
        Logger logger = LoggerFactory.getLogger(MongodProcess.class);
        return new ProcessOutput((IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.TRACE), (IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.WARN), (IStreamProcessor)new Slf4jStreamProcessor(logger, Slf4jLevel.INFO));
    }

    private IRuntimeConfig buildRuntimeConfig() {
        return new RuntimeConfigBuilder().defaults(Command.MongoD).processOutput(this.buildOutputConfig()).artifactStore(this.buildArtifactStore()).build();
    }

    private IArtifactStore buildArtifactStore() {
        Logger logger = LoggerFactory.getLogger(Downloader.class);
        return new ArtifactStoreBuilder().defaults(Command.MongoD).download(new DownloadConfigBuilder().defaultsForCommand(Command.MongoD).progressListener((IProgressListener)new Slf4jProgressListener(logger)).build()).build();
    }

    private MongodConfig buildMongodConfig() throws UnknownHostException {
        return new MongodConfig(this.parseVersion(this.version), new AbstractMongoConfig.Net(this.getBindIp(), this.getPort(), Network.localhostIsIPv6()), new AbstractMongoConfig.Storage(), new AbstractMongoConfig.Timeout());
    }

    private IVersion parseVersion(String version) {
        if (version == null) {
            return Version.Main.PRODUCTION;
        }
        String versionEnumName = version.toUpperCase().replaceAll("\\.", "_");
        if (version.charAt(0) != 'V') {
            versionEnumName = "V" + versionEnumName;
        }
        try {
            return Version.Main.valueOf((String)versionEnumName);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Unrecognised MongoDB version '{}', this might be a new version that we don't yet know about. Attempting download anyway...", (Object)version);
            return new GenericVersion(version);
        }
    }
}

