/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.boot.inheritchannel.jetty;

import cz.jirutka.spring.boot.inheritchannel.jetty.InheritChannelServerConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.util.Assert;

public class InheritChannelJettyServerCustomizer
implements JettyServerCustomizer {
    protected static final Log LOG = LogFactory.getLog(InheritChannelJettyServerCustomizer.class);

    public void customize(Server server) {
        Connector[] connectors = server.getConnectors();
        if (connectors.length > 1) {
            LOG.warn((Object)"Server has more than one Connector, only the first one will inherit channel");
        }
        if (connectors.length > 0) {
            Connector connector = connectors[0];
            Assert.isInstanceOf(ServerConnector.class, (Object)connector);
            connectors[0] = new InheritChannelServerConnector((ServerConnector)connector);
        } else {
            connectors = new Connector[]{new InheritChannelServerConnector(server)};
        }
        server.setConnectors(connectors);
    }
}

