/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.boot.inheritchannel.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.springframework.util.Assert;

public class InheritChannelServerConnector
extends ServerConnector {
    public InheritChannelServerConnector(ServerConnector connector) {
        this(connector.getServer(), connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), connector.getAcceptors(), connector.getSelectorManager().getSelectorCount(), connector.getConnectionFactories().toArray(new ConnectionFactory[1]));
        this.removeBean(connector.getSelectorManager());
    }

    public InheritChannelServerConnector(Server server) {
        this(server, null, null, null, -1, -1, new ConnectionFactory[]{new HttpConnectionFactory()});
    }

    public InheritChannelServerConnector(Server server, int acceptors, int selectors) {
        this(server, null, null, null, acceptors, selectors, new ConnectionFactory[]{new HttpConnectionFactory()});
    }

    public InheritChannelServerConnector(Server server, int acceptors, int selectors, ConnectionFactory ... factories) {
        this(server, null, null, null, acceptors, selectors, factories);
    }

    public InheritChannelServerConnector(Server server, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, -1, factories);
    }

    public InheritChannelServerConnector(Server server, SslContextFactory sslContextFactory) {
        this(server, -1, -1, sslContextFactory);
    }

    public InheritChannelServerConnector(Server server, int acceptors, int selectors, SslContextFactory sslContextFactory) {
        this(server, null, null, null, acceptors, selectors, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()}));
    }

    public InheritChannelServerConnector(Server server, SslContextFactory sslContextFactory, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, -1, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])factories));
    }

    public InheritChannelServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, acceptors, selectors, factories);
        this.setPort(0);
        this.setInheritChannel(true);
    }

    public void open() throws IOException {
        if (this.getTransport() == null) {
            Channel channel = System.inheritedChannel();
            if (channel == null) {
                throw new SocketException("No inherited channel is available! Expected a TCP socket passed as STDIN.");
            }
            if (!(channel instanceof ServerSocketChannel)) {
                throw new SocketException("Inherited channel is not a ServerSocketChannel, but " + channel.getClass());
            }
        }
        super.open();
    }

    public int getLocalPort() {
        Object channel = this.getTransport();
        if (channel != null) {
            Assert.state((boolean)(channel instanceof ServerSocketChannel), (String)("Inherited channel is not of type ServerSocketChannel: " + channel.toString()));
            try {
                SocketAddress address = ((ServerSocketChannel)channel).getLocalAddress();
                if (address instanceof InetSocketAddress) {
                    return ((InetSocketAddress)address).getPort();
                }
            }
            catch (IOException ex) {
                this.LOG.warn("Unable to get port number from the inherited channel: {}", new Object[]{channel});
            }
        }
        return super.getLocalPort();
    }

    public void setInheritChannel(boolean inheritChannel) {
        Assert.isTrue((boolean)inheritChannel, (String)"This class should be used only with inheritChannel");
        super.setInheritChannel(true);
    }
}

