/*
 * Copyright 2012-2014 Tomasz Nurkiewicz <nurkiewicz@gmail.com>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.nurkiewicz.jdbcrepository;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TableDescription {

    private final String name;
    private final List<String> idColumns;
    private final String fromClause;


    public TableDescription(String name, String fromClause, String... idColumns) {
        Assert.notNull(name);
        Assert.notNull(idColumns);
        Assert.isTrue(idColumns.length > 0, "At least one primary key column must be provided");

        this.name = name;
        this.idColumns = Collections.unmodifiableList(Arrays.asList(idColumns));
        this.fromClause = StringUtils.hasText(fromClause) ? fromClause : name;
    }

    public TableDescription(String name, String idColumn) {
        this(name, null, idColumn);
    }


    public String getName() {
        return name;
    }

    public List<String> getIdColumns() {
        return idColumns;
    }

    public String getFromClause() {
        return fromClause;
    }
}
