/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.jdbcrepository;

import com.nurkiewicz.jdbcrepository.MissingRowUnmapper;
import com.nurkiewicz.jdbcrepository.RowUnmapper;
import com.nurkiewicz.jdbcrepository.TableDescription;
import com.nurkiewicz.jdbcrepository.sql.SqlGenerator;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

public abstract class JdbcRepository<T extends Persistable<ID>, ID extends Serializable>
implements PagingAndSortingRepository<T, ID>,
InitializingBean,
BeanFactoryAware {
    private final TableDescription table;
    private final RowMapper<T> rowMapper;
    private final RowUnmapper<T> rowUnmapper;
    private SqlGenerator sqlGenerator;
    private BeanFactory beanFactory;
    private JdbcOperations jdbcOperations;

    public JdbcRepository(RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper, SqlGenerator sqlGenerator, TableDescription table) {
        Assert.notNull(rowMapper);
        Assert.notNull(rowUnmapper);
        Assert.notNull((Object)table);
        this.rowUnmapper = rowUnmapper;
        this.rowMapper = rowMapper;
        this.sqlGenerator = sqlGenerator;
        this.table = table;
    }

    public JdbcRepository(RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper, TableDescription table) {
        this(rowMapper, rowUnmapper, null, table);
    }

    public JdbcRepository(RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper, String tableName, String idColumn) {
        this(rowMapper, rowUnmapper, null, new TableDescription(tableName, idColumn));
    }

    public JdbcRepository(RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper, String tableName) {
        this(rowMapper, rowUnmapper, new TableDescription(tableName, "id"));
    }

    public JdbcRepository(RowMapper<T> rowMapper, TableDescription table) {
        this(rowMapper, new MissingRowUnmapper(), null, table);
    }

    public JdbcRepository(RowMapper<T> rowMapper, String tableName, String idColumn) {
        this(rowMapper, new MissingRowUnmapper(), null, new TableDescription(tableName, idColumn));
    }

    public JdbcRepository(RowMapper<T> rowMapper, String tableName) {
        this(rowMapper, new MissingRowUnmapper(), new TableDescription(tableName, "id"));
    }

    @Deprecated
    public static Object[] pk(Object ... idValues) {
        return idValues;
    }

    public void afterPropertiesSet() throws Exception {
        this.obtainJdbcTemplate();
        if (this.sqlGenerator == null) {
            this.obtainSqlGenerator();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setSqlGenerator(SqlGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcOperations = new JdbcTemplate(dataSource);
    }

    public long count() {
        return (Long)this.jdbcOperations.queryForObject(this.sqlGenerator.count(this.table), Long.class);
    }

    public void delete(ID id) {
        this.jdbcOperations.update(this.sqlGenerator.deleteById(this.table), JdbcRepository.idToObjectArray(id));
    }

    public void delete(T entity) {
        this.jdbcOperations.update(this.sqlGenerator.deleteById(this.table), JdbcRepository.idToObjectArray(entity.getId()));
    }

    public void delete(Iterable<? extends T> entities) {
        for (Persistable t : entities) {
            this.delete((T)t);
        }
    }

    public void deleteAll() {
        this.jdbcOperations.update(this.sqlGenerator.deleteAll(this.table));
    }

    public boolean exists(ID id) {
        return !this.jdbcOperations.queryForList(this.sqlGenerator.existsById(this.table), JdbcRepository.idToObjectArray(id), Integer.class).isEmpty();
    }

    public List<T> findAll() {
        return this.jdbcOperations.query(this.sqlGenerator.selectAll(this.table), this.rowMapper);
    }

    public T findOne(ID id) {
        Object[] idColumns = JdbcRepository.idToObjectArray(id);
        List entityOrEmpty = this.jdbcOperations.query(this.sqlGenerator.selectById(this.table), idColumns, this.rowMapper);
        return (T)(entityOrEmpty.isEmpty() ? null : (Persistable)entityOrEmpty.get(0));
    }

    public <S extends T> S save(S entity) {
        return entity.isNew() ? this.create(entity) : this.update(entity);
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        ArrayList<Persistable> ret = new ArrayList<Persistable>();
        for (Persistable s : entities) {
            ret.add(this.save((S)s));
        }
        return ret;
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        List<ID> idsList = JdbcRepository.toList(ids);
        if (idsList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.jdbcOperations.query(this.sqlGenerator.selectByIds(this.table, idsList.size()), this.rowMapper, JdbcRepository.flatten(idsList));
    }

    public List<T> findAll(Sort sort) {
        return this.jdbcOperations.query(this.sqlGenerator.selectAll(this.table, sort), this.rowMapper);
    }

    public Page<T> findAll(Pageable page) {
        String query = this.sqlGenerator.selectAll(this.table, page);
        return new PageImpl(this.jdbcOperations.query(query, this.rowMapper), page, this.count());
    }

    public <S extends T> S update(S entity) {
        Map<String, Object> columns = this.preUpdate(entity, this.columns(entity));
        List<Object> idValues = this.removeIdColumns(columns);
        String updateQuery = this.sqlGenerator.update(this.table, columns);
        int i = 0;
        while (i < this.table.getIdColumns().size()) {
            columns.put(this.table.getIdColumns().get(i), idValues.get(i));
            ++i;
        }
        Object[] queryParams = columns.values().toArray();
        int rowsAffected = this.jdbcOperations.update(updateQuery, queryParams);
        return this.postUpdate(entity, rowsAffected);
    }

    public <S extends T> S create(S entity) {
        Map<String, Object> columns = this.preCreate(this.columns(entity), entity);
        return entity.getId() == null ? this.createWithAutoGeneratedKey(entity, columns) : this.createWithManuallyAssignedKey(entity, columns);
    }

    protected TableDescription getTable() {
        return this.table;
    }

    protected Map<String, Object> preCreate(Map<String, Object> columns, T entity) {
        return columns;
    }

    protected <S extends T> S postCreate(S entity, Number generatedId) {
        return entity;
    }

    protected Map<String, Object> preUpdate(T entity, Map<String, Object> columns) {
        return columns;
    }

    protected <S extends T> S postUpdate(S entity, int rowsAffected) {
        return this.postUpdate(entity);
    }

    protected <S extends T> S postUpdate(S entity) {
        return entity;
    }

    private void obtainSqlGenerator() {
        try {
            this.sqlGenerator = (SqlGenerator)this.beanFactory.getBean(SqlGenerator.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            this.sqlGenerator = new SqlGenerator();
        }
    }

    private void obtainJdbcTemplate() {
        try {
            this.jdbcOperations = (JdbcOperations)this.beanFactory.getBean(JdbcOperations.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            DataSource dataSource = (DataSource)this.beanFactory.getBean(DataSource.class);
            this.jdbcOperations = new JdbcTemplate(dataSource);
        }
    }

    private <S extends T> S createWithManuallyAssignedKey(S entity, Map<String, Object> columns) {
        String createQuery = this.sqlGenerator.create(this.table, columns);
        Object[] queryParams = columns.values().toArray();
        this.jdbcOperations.update(createQuery, queryParams);
        return this.postCreate(entity, null);
    }

    private <S extends T> S createWithAutoGeneratedKey(S entity, Map<String, Object> columns) {
        this.removeIdColumns(columns);
        final String createQuery = this.sqlGenerator.create(this.table, columns);
        final Object[] queryParams = columns.values().toArray();
        GeneratedKeyHolder key = new GeneratedKeyHolder();
        this.jdbcOperations.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String idColumnName = JdbcRepository.this.table.getIdColumns().get(0);
                PreparedStatement ps = con.prepareStatement(createQuery, new String[]{idColumnName});
                int i = 0;
                while (i < queryParams.length) {
                    ps.setObject(i + 1, queryParams[i]);
                    ++i;
                }
                return ps;
            }
        }, (KeyHolder)key);
        return this.postCreate(entity, key.getKey());
    }

    private List<Object> removeIdColumns(Map<String, Object> columns) {
        ArrayList<Object> idColumnsValues = new ArrayList<Object>(columns.size());
        for (String idColumn : this.table.getIdColumns()) {
            idColumnsValues.add(columns.remove(idColumn));
        }
        return idColumnsValues;
    }

    private static <ID> Object[] idToObjectArray(ID id) {
        Object[] objectArray;
        if (id instanceof Object[]) {
            objectArray = (Object[])id;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = id;
        }
        return objectArray;
    }

    private static <ID> List<Object> idToObjectList(ID id) {
        return id instanceof Object[] ? Arrays.asList((Object[])id) : Collections.singletonList(id);
    }

    private Map<String, Object> columns(T entity) {
        LinkedCaseInsensitiveMap columns = new LinkedCaseInsensitiveMap();
        columns.putAll(this.rowUnmapper.mapColumns(entity));
        return columns;
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    private static <ID> Object[] flatten(List<ID> ids) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ID id : ids) {
            result.addAll(JdbcRepository.idToObjectList(id));
        }
        return result.toArray();
    }
}

