/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.jdbcrepository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TableDescription {
    private final String name;
    private final List<String> idColumns;
    private final String fromClause;

    public TableDescription(String name, String fromClause, String ... idColumns) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)idColumns);
        Assert.isTrue((idColumns.length > 0 ? 1 : 0) != 0, (String)"At least one primary key column must be provided");
        this.name = name;
        this.idColumns = Collections.unmodifiableList(Arrays.asList(idColumns));
        this.fromClause = StringUtils.hasText((String)fromClause) ? fromClause : name;
    }

    public TableDescription(String name, String idColumn) {
        this(name, null, idColumn);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdColumns() {
        return this.idColumns;
    }

    public String getFromClause() {
        return this.fromClause;
    }
}

