/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.jdbcrepository.sql;

import com.nurkiewicz.jdbcrepository.TableDescription;
import com.nurkiewicz.jdbcrepository.sql.AbstractMssqlSqlGenerator;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

public class Mssql2012SqlGenerator
extends AbstractMssqlSqlGenerator {
    private static final String MSSQL_DEFAULT_SORT_CLAUSE = " ORDER BY 1 ASC";

    @Override
    public String selectAll(TableDescription table, Pageable page) {
        int offset = page.getPageNumber() * page.getPageSize() + 1;
        String sortingClause = this.sortingClauseIfRequired(page.getSort());
        if (!StringUtils.hasText((String)sortingClause)) {
            sortingClause = MSSQL_DEFAULT_SORT_CLAUSE;
        }
        String paginationClause = String.format(" OFFSET %d ROWS FETCH NEXT %d ROW ONLY", offset - 1, page.getPageSize());
        return String.valueOf(super.selectAll(table)) + sortingClause + paginationClause;
    }
}

