/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.jdbcrepository.sql;

import com.nurkiewicz.jdbcrepository.TableDescription;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SqlGenerator {
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String SELECT = "SELECT ";
    public static final String FROM = "FROM ";
    public static final String DELETE = "DELETE ";
    public static final String COMMA = ", ";
    public static final String PARAM = " = ?";
    private String allColumnsClause;

    public SqlGenerator(String allColumnsClause) {
        this.allColumnsClause = allColumnsClause;
    }

    public SqlGenerator() {
        this("*");
    }

    public String count(TableDescription table) {
        return "SELECT COUNT(*) FROM " + table.getFromClause();
    }

    public String deleteById(TableDescription table) {
        return "DELETE FROM " + table.getName() + this.whereByIdClause(table);
    }

    public String selectAll(TableDescription table) {
        return SELECT + this.allColumnsClause + ' ' + FROM + table.getFromClause();
    }

    public String selectAll(TableDescription table, Pageable page) {
        return String.valueOf(this.selectAll(table, page.getSort())) + this.limitClause(page);
    }

    public String selectAll(TableDescription table, Sort sort) {
        return String.valueOf(this.selectAll(table)) + this.sortingClauseIfRequired(sort);
    }

    public String selectById(TableDescription table) {
        return String.valueOf(this.selectAll(table)) + this.whereByIdClause(table);
    }

    public String selectByIds(TableDescription table, int idsCount) {
        switch (idsCount) {
            case 0: {
                return this.selectAll(table);
            }
            case 1: {
                return this.selectById(table);
            }
        }
        return String.valueOf(this.selectAll(table)) + this.whereByIdsClause(table, idsCount);
    }

    public String update(TableDescription table, Map<String, Object> columns) {
        StringBuilder updateQuery = new StringBuilder("UPDATE " + table.getName() + " SET ");
        Iterator<Map.Entry<String, Object>> it = columns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> column = it.next();
            updateQuery.append(column.getKey()).append(PARAM);
            if (!it.hasNext()) continue;
            updateQuery.append(COMMA);
        }
        updateQuery.append(this.whereByIdClause(table));
        return updateQuery.toString();
    }

    public String create(TableDescription table, Map<String, Object> columns) {
        StringBuilder createQuery = new StringBuilder("INSERT INTO " + table.getName() + " (");
        this.appendColumnNames(createQuery, columns.keySet());
        createQuery.append(") VALUES (").append(SqlGenerator.repeat("?", COMMA, columns.size()));
        return createQuery.append(')').toString();
    }

    public String deleteAll(TableDescription table) {
        return "DELETE FROM " + table.getName();
    }

    public String countById(TableDescription table) {
        return String.valueOf(this.count(table)) + this.whereByIdClause(table);
    }

    public String existsById(TableDescription table) {
        return "SELECT 1 FROM " + table.getName() + this.whereByIdClause(table);
    }

    public String getAllColumnsClause() {
        return this.allColumnsClause;
    }

    protected String limitClause(Pageable page) {
        int offset = page.getPageNumber() * page.getPageSize();
        return " LIMIT " + offset + COMMA + page.getPageSize();
    }

    protected String sortingClauseIfRequired(Sort sort) {
        if (sort == null) {
            return "";
        }
        StringBuilder orderByClause = new StringBuilder();
        orderByClause.append(" ORDER BY ");
        Iterator iterator = sort.iterator();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            orderByClause.append(order.getProperty()).append(' ').append(order.getDirection().toString());
            if (!iterator.hasNext()) continue;
            orderByClause.append(COMMA);
        }
        return orderByClause.toString();
    }

    private String whereByIdClause(TableDescription table) {
        StringBuilder whereClause = new StringBuilder(WHERE);
        Iterator<String> it = table.getIdColumns().iterator();
        while (it.hasNext()) {
            whereClause.append(it.next()).append(PARAM);
            if (!it.hasNext()) continue;
            whereClause.append(AND);
        }
        return whereClause.toString();
    }

    private String whereByIdsClause(TableDescription table, int idsCount) {
        List<String> idColumnNames = table.getIdColumns();
        if (idColumnNames.size() > 1) {
            return this.whereByIdsWithMultipleIdColumns(idsCount, idColumnNames);
        }
        return this.whereByIdsWithSingleIdColumn(idsCount, idColumnNames.get(0));
    }

    private String whereByIdsWithMultipleIdColumns(int idsCount, List<String> idColumnNames) {
        int idColumnsCount = idColumnNames.size();
        int totalParams = idsCount * idColumnsCount;
        StringBuilder whereClause = new StringBuilder(WHERE);
        int idColumnIdx = 0;
        while (idColumnIdx < totalParams) {
            if (idColumnIdx > 0) {
                whereClause.append(OR);
            }
            whereClause.append('(');
            int i = 0;
            while (i < idColumnsCount) {
                if (i > 0) {
                    whereClause.append(AND);
                }
                whereClause.append(idColumnNames.get(i)).append(PARAM);
                ++i;
            }
            whereClause.append(')');
            idColumnIdx += idColumnsCount;
        }
        return whereClause.toString();
    }

    private String whereByIdsWithSingleIdColumn(int idsCount, String idColumn) {
        return WHERE + idColumn + " IN (" + SqlGenerator.repeat("?", COMMA, idsCount) + ')';
    }

    private void appendColumnNames(StringBuilder createQuery, Set<String> columnNames) {
        Iterator<String> it = columnNames.iterator();
        while (it.hasNext()) {
            String column = it.next();
            createQuery.append(column);
            if (!it.hasNext()) continue;
            createQuery.append(COMMA);
        }
    }

    private static String repeat(String s, String separator, int count) {
        StringBuilder string = new StringBuilder((s.length() + separator.length()) * count);
        while (--count > 0) {
            string.append(s).append(separator);
        }
        return string.append(s).toString();
    }
}

