/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.handlers;

import cz.jirutka.spring.exhandler.handlers.RestExceptionHandler;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class AbstractRestExceptionHandler<E extends Exception, T>
implements RestExceptionHandler<E, T> {
    private static final Logger LOG = LoggerFactory.getLogger(RestExceptionHandler.class);
    private final Class<E> exceptionClass;
    private final HttpStatus status;

    protected AbstractRestExceptionHandler(HttpStatus status) {
        this.exceptionClass = this.determineTargetType();
        this.status = status;
        LOG.trace("Determined generic exception type: {}", (Object)this.exceptionClass.getName());
    }

    protected AbstractRestExceptionHandler(Class<E> exceptionClass, HttpStatus status) {
        this.exceptionClass = exceptionClass;
        this.status = status;
    }

    public abstract T createBody(E var1, HttpServletRequest var2);

    @Override
    public ResponseEntity<T> handleException(E ex, HttpServletRequest req) {
        this.logException(ex, req);
        T body = this.createBody(ex, req);
        HttpHeaders headers = this.createHeaders(ex, req);
        return new ResponseEntity(body, (MultiValueMap)headers, this.getStatus());
    }

    public Class<E> getExceptionClass() {
        return this.exceptionClass;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    protected HttpHeaders createHeaders(E ex, HttpServletRequest req) {
        return new HttpHeaders();
    }

    protected void logException(E ex, HttpServletRequest req) {
        if (LOG.isErrorEnabled() && this.getStatus().value() >= 500 || LOG.isInfoEnabled()) {
            Marker marker = MarkerFactory.getMarker((String)ex.getClass().getName());
            String uri = req.getRequestURI();
            if (req.getQueryString() != null) {
                uri = String.valueOf(uri) + '?' + req.getQueryString();
            }
            String msg = String.format("%s %s ~> %s", req.getMethod(), uri, this.getStatus());
            if (this.getStatus().value() >= 500) {
                LOG.error(marker, msg, ex);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(marker, msg, ex);
            } else {
                LOG.info(marker, msg);
            }
        }
    }

    private Class<E> determineTargetType() {
        return GenericTypeResolver.resolveTypeArguments(this.getClass(), AbstractRestExceptionHandler.class)[0];
    }
}

