/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.handlers;

import cz.jirutka.spring.exhandler.handlers.ErrorMessageRestExceptionHandler;
import cz.jirutka.spring.exhandler.messages.ErrorMessage;
import cz.jirutka.spring.exhandler.messages.ValidationErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConstraintViolationExceptionHandler
extends ErrorMessageRestExceptionHandler<ConstraintViolationException> {
    private ConversionService conversionService = new DefaultConversionService();

    public ConstraintViolationExceptionHandler() {
        super(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Override
    public ValidationErrorMessage createBody(ConstraintViolationException ex, HttpServletRequest req) {
        Object tmpl = super.createBody((Exception)ex, req);
        ValidationErrorMessage msg = new ValidationErrorMessage((ErrorMessage)tmpl);
        for (ConstraintViolation violation : ex.getConstraintViolations()) {
            Path.Node pathNode = this.findLastNonEmptyPathNode(violation.getPropertyPath());
            if (pathNode != null && pathNode.getKind() == ElementKind.PROPERTY) {
                msg.addError(pathNode.getName(), this.convertToString(violation.getInvalidValue()), violation.getMessage());
                continue;
            }
            msg.addError(violation.getMessage());
        }
        return msg;
    }

    @Autowired(required=false)
    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    private Path.Node findLastNonEmptyPathNode(Path path) {
        ArrayList<Path.Node> list = new ArrayList<Path.Node>();
        Iterator it = path.iterator();
        while (it.hasNext()) {
            list.add((Path.Node)it.next());
        }
        Collections.reverse(list);
        for (Path.Node node : list) {
            if (StringUtils.isEmpty((Object)node.getName())) continue;
            return node;
        }
        return null;
    }

    private String convertToString(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        try {
            return (String)this.conversionService.convert(invalidValue, String.class);
        }
        catch (ConversionException conversionException) {
            return invalidValue.toString();
        }
    }
}

