/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.handlers;

import cz.jirutka.spring.exhandler.handlers.ErrorMessageRestExceptionHandler;
import cz.jirutka.spring.exhandler.messages.ErrorMessage;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class HttpRequestMethodNotSupportedExceptionHandler
extends ErrorMessageRestExceptionHandler<HttpRequestMethodNotSupportedException> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.springframework.web.servlet.PageNotFound");

    public HttpRequestMethodNotSupportedExceptionHandler() {
        super(HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    public ResponseEntity<ErrorMessage> handleException(HttpRequestMethodNotSupportedException ex, HttpServletRequest req) {
        LOG.warn(ex.getMessage());
        return super.handleException(ex, req);
    }

    @Override
    protected HttpHeaders createHeaders(HttpRequestMethodNotSupportedException ex, HttpServletRequest req) {
        HttpHeaders headers = super.createHeaders(ex, req);
        if (!ObjectUtils.isEmpty((Object[])ex.getSupportedMethods())) {
            headers.setAllow(ex.getSupportedHttpMethods());
        }
        return headers;
    }
}

