/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler;

import cz.jirutka.spring.exhandler.RestHandlerExceptionResolverBuilder;
import cz.jirutka.spring.exhandler.handlers.RestExceptionHandler;
import cz.jirutka.spring.exhandler.support.HttpMessageConverterUtils;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.FixedContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;

public class RestHandlerExceptionResolver
extends AbstractHandlerExceptionResolver
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(RestHandlerExceptionResolver.class);
    private final MethodParameter returnTypeMethodParam;
    private List<HttpMessageConverter<?>> messageConverters = HttpMessageConverterUtils.getDefaultHttpMessageConverters();
    private Map<Class<? extends Exception>, RestExceptionHandler> handlers = new LinkedHashMap<Class<? extends Exception>, RestExceptionHandler>();
    private MediaType defaultContentType = MediaType.APPLICATION_XML;
    private ContentNegotiationManager contentNegotiationManager;
    HandlerMethodReturnValueHandler responseProcessor;
    HandlerMethodReturnValueHandler fallbackResponseProcessor;

    public static RestHandlerExceptionResolverBuilder builder() {
        return new RestHandlerExceptionResolverBuilder();
    }

    public RestHandlerExceptionResolver() {
        Method method = ClassUtils.getMethod(RestExceptionHandler.class, (String)"handleException", (Class[])new Class[]{Exception.class, HttpServletRequest.class});
        this.returnTypeMethodParam = new MethodParameter(method, -1);
        this.returnTypeMethodParam.getGenericParameterType();
    }

    public void afterPropertiesSet() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = new ContentNegotiationManager(new ContentNegotiationStrategy[]{new HeaderContentNegotiationStrategy(), new FixedContentNegotiationStrategy(this.defaultContentType)});
        }
        this.responseProcessor = new HttpEntityMethodProcessor(this.messageConverters, this.contentNegotiationManager);
        this.fallbackResponseProcessor = new HttpEntityMethodProcessor(this.messageConverters, new ContentNegotiationManager(new ContentNegotiationStrategy[]{new FixedContentNegotiationStrategy(this.defaultContentType)}));
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        ResponseEntity<?> entity;
        try {
            entity = this.handleException(exception, request);
        }
        catch (NoExceptionHandlerFoundException noExceptionHandlerFoundException) {
            LOG.warn("No exception handler found to handle exception: {}", (Object)exception.getClass().getName());
            return null;
        }
        try {
            this.processResponse(entity, (NativeWebRequest)new ServletWebRequest(request, response));
        }
        catch (Exception ex) {
            LOG.error("Failed to process error response: {}", entity, (Object)ex);
            return null;
        }
        return new ModelAndView();
    }

    protected ResponseEntity<?> handleException(Exception exception, HttpServletRequest request) {
        request.removeAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        RestExceptionHandler<Exception, ?> handler = this.resolveExceptionHandler(exception.getClass());
        LOG.debug("Handling exception {} with response factory: {}", (Object)exception.getClass().getName(), handler);
        return handler.handleException(exception, request);
    }

    protected RestExceptionHandler<Exception, ?> resolveExceptionHandler(Class<? extends Exception> exceptionClass) {
        Class<? extends Exception> clazz = exceptionClass;
        while (clazz != Throwable.class) {
            if (this.handlers.containsKey(clazz)) {
                return this.handlers.get(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoExceptionHandlerFoundException();
    }

    protected void processResponse(ResponseEntity<?> entity, NativeWebRequest webRequest) throws Exception {
        MethodParameter methodParameter = new MethodParameter(this.returnTypeMethodParam);
        ModelAndViewContainer mavContainer = new ModelAndViewContainer();
        try {
            this.responseProcessor.handleReturnValue(entity, methodParameter, mavContainer, webRequest);
        }
        catch (HttpMediaTypeNotAcceptableException httpMediaTypeNotAcceptableException) {
            LOG.debug("Requested media type is not supported, falling back to default one");
            this.fallbackResponseProcessor.handleReturnValue(entity, methodParameter, mavContainer, webRequest);
        }
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"messageConverters must not be null");
        this.messageConverters = messageConverters;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager != null ? contentNegotiationManager : new ContentNegotiationManager();
    }

    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public Map<Class<? extends Exception>, RestExceptionHandler> getExceptionHandlers() {
        return this.handlers;
    }

    public void setExceptionHandlers(Map<Class<? extends Exception>, RestExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    public static class NoExceptionHandlerFoundException
    extends RuntimeException {
    }
}

