/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.unboundid;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class InMemoryDirectoryServerFactoryBean
implements FactoryBean<InMemoryDirectoryServer>,
DisposableBean,
InitializingBean {
    public static final String BIND_DN = "cn=Directory Manager";
    public static final String BIND_PASSWORD = "password";
    private List<String> baseDNs;
    private List<Resource> schemaFiles = Collections.emptyList();
    private List<Resource> ldifFiles = Collections.emptyList();
    private boolean loadDefaultSchemas = true;
    private InMemoryDirectoryServer server;

    public InMemoryDirectoryServer getObject() throws LDAPException, LDIFException, IOException {
        ArrayList<Schema> schemas = new ArrayList<Schema>(this.schemaFiles.size() + 1);
        String[] baseDNsArray = this.baseDNs.toArray(new String[0]);
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(baseDNsArray);
        config.addAdditionalBindCredentials(BIND_DN, BIND_PASSWORD);
        if (this.loadDefaultSchemas) {
            schemas.add(Schema.getDefaultStandardSchema());
        }
        for (Resource resource : this.schemaFiles) {
            schemas.add(Schema.getSchema((File[])new File[]{resource.getFile()}));
        }
        Schema mergedSchema = Schema.mergeSchemas((Schema[])schemas.toArray(new Schema[schemas.size()]));
        config.setSchema(mergedSchema);
        this.server = new InMemoryDirectoryServer(config);
        for (Resource resource : this.ldifFiles) {
            this.server.importFromLDIF(false, new LDIFReader(resource.getFile()));
        }
        this.server.startListening();
        return this.server;
    }

    public Class<InMemoryDirectoryServer> getObjectType() {
        return InMemoryDirectoryServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.server != null) {
            this.server.shutDown(true);
        }
    }

    public void afterPropertiesSet() {
        Assert.notEmpty(this.baseDNs, (String)"At least one base DN must be provided.");
    }

    public void setBaseDNs(List<String> baseDNs) {
        Assert.notEmpty(baseDNs, (String)"At least one base DN must be provided");
        this.baseDNs = baseDNs;
    }

    public void setBaseDN(String baseDN) {
        this.baseDNs = Arrays.asList(baseDN);
    }

    public void setSchemaFiles(List<Resource> schemaFiles) {
        this.schemaFiles = schemaFiles;
    }

    public void setSchemaFile(Resource schema) {
        this.schemaFiles = Arrays.asList(schema);
    }

    public void setLdifFiles(List<Resource> ldifFiles) {
        this.ldifFiles = ldifFiles;
    }

    public void setLdifFile(Resource ldifFile) {
        this.ldifFiles = Arrays.asList(ldifFile);
    }

    public void setLoadDefaultSchemas(boolean loadDefaultSchemas) {
        this.loadDefaultSchemas = loadDefaultSchemas;
    }
}

