/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.unboundid;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LdapConnectionFactoryBean
implements FactoryBean<LDAPConnection>,
DisposableBean,
InitializingBean {
    private static final int DEFAULT_PORT = 389;
    private static final int DEFAULT_SSL_PORT = 636;
    private String host;
    private int port = -1;
    private String bindDN;
    private String password;
    private boolean ssl = false;
    private boolean sslTrustAll = false;
    private TrustManager sslTrustManager;
    private LDAPConnection connection;

    public LDAPConnection getObject() throws GeneralSecurityException, LDAPException {
        if (this.ssl && this.sslTrustAll) {
            this.sslTrustManager = new TrustAllTrustManager();
        }
        SocketFactory socketFactory = this.sslTrustManager != null ? new SSLUtil(this.sslTrustManager).createSSLSocketFactory() : (this.ssl ? SSLSocketFactory.getDefault() : SocketFactory.getDefault());
        this.connection = new LDAPConnection(socketFactory, this.host, this.port);
        if (StringUtils.hasText((String)this.bindDN) && StringUtils.hasText((String)this.password)) {
            this.connection.bind(this.bindDN, this.password);
        }
        return this.connection;
    }

    public Class<LDAPConnection> getObjectType() {
        return LDAPConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.host, (String)"host or URL must be provided");
        if (this.port < 1) {
            this.port = this.ssl ? 636 : 389;
        }
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void setUrl(String url) throws LDAPException {
        LDAPURL ldapUrl = new LDAPURL(url);
        this.host = ldapUrl.getHost();
        this.port = ldapUrl.getPort();
        this.ssl = "ldaps".equals(ldapUrl.getScheme());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        Assert.isTrue((port > 0 && port < 65536 ? 1 : 0) != 0, (String)"port must be between 1 and 65535");
        this.port = port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSslTrustAll(boolean sslTrustAll) {
        this.sslTrustAll = sslTrustAll;
    }

    public void setSslTrustManager(TrustManager sslTrustManager) {
        this.sslTrustManager = sslTrustManager;
    }
}

