/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection;

import cz.jirutka.validator.collection.support.LRUCache;
import cz.jirutka.validator.collection.support.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEachValidator
implements ConstraintValidator<Annotation, Collection<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(CommonEachValidator.class);
    private static final ConstraintHelper CONSTRAINT_HELPER = new ConstraintHelper();
    @Inject
    private ValidatorFactory factory;
    private List<ConstraintDescriptor> descriptors;
    private Map<Class, Class<? extends ConstraintValidator<?, ?>>> validators;
    private Map<Class, ConstraintValidator> validatorInstancesCache;

    public void initialize(Annotation wrapper) {
        LOG.trace("Initializing BaseEachValidator for {}", wrapper.annotationType());
        if (this.factory == null) {
            LOG.debug("No ValidatorFactory injected, building default one");
            this.factory = Validation.buildDefaultValidatorFactory();
        }
        Object[] constraints = this.unwrapConstraints(wrapper);
        Validate.notEmpty((Object[])constraints, (String)"Wrapper annotation does not contain any constraint", (Object[])new Object[0]);
        Class<? extends Annotation> constraintClass = constraints[0].annotationType();
        this.descriptors = new ArrayList<ConstraintDescriptor>(2);
        for (Object constraint : constraints) {
            this.descriptors.add(this.createConstraintDescriptor((Annotation)constraint));
        }
        ConstraintDescriptor descriptor = this.descriptors.get(0);
        this.validators = this.categorizeValidatorsByType(descriptor.getConstraintValidatorClasses());
        Validate.notEmpty(this.validators, (String)"No validator found for constraint: %s", (Object[])new Object[]{constraintClass.getName()});
        this.validatorInstancesCache = new LRUCache<Class, ConstraintValidator>(1, 6);
    }

    public boolean isValid(Collection<?> collection, ConstraintValidatorContext context) {
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        int index = 0;
        for (Object element : collection) {
            if (element != null) {
                ConstraintValidator validator = this.getCachedValidator(element.getClass());
                for (ConstraintDescriptor descriptor : this.descriptors) {
                    validator.initialize(descriptor.getAnnotation());
                    if (validator.isValid(element, context)) continue;
                    LOG.debug("Element [{}] = '{}' is invalid according to: {}", new Object[]{index, element, validator.getClass().getName()});
                    String message = this.createMessage(descriptor, element);
                    context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public void setValidatorFactory(ValidatorFactory factory) {
        this.factory = factory;
    }

    protected Annotation[] unwrapConstraints(Annotation wrapper) {
        return ReflectionUtils.invokeArrayGetter("value", Annotation.class, wrapper);
    }

    protected ConstraintDescriptor createConstraintDescriptor(Annotation constraint) {
        return new ConstraintDescriptorImpl(null, constraint, CONSTRAINT_HELPER, ElementType.LOCAL_VARIABLE, ConstraintOrigin.DEFINED_LOCALLY);
    }

    protected <T extends ConstraintValidator<?, ?>> Map<Class, Class<? extends T>> categorizeValidatorsByType(List<Class<? extends T>> validatorClasses) {
        LinkedHashMap<Class, Class<T>> validators = new LinkedHashMap<Class, Class<T>>(10);
        for (Class<T> validator : validatorClasses) {
            Class<?> type = this.determineTargetType(validator);
            if (type.isArray()) continue;
            LOG.trace("Found validator {} for type {}", (Object)validator.getName(), (Object)type.getName());
            validators.put(type, validator);
        }
        return validators;
    }

    protected Class<?> determineTargetType(Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        TypeVariable typeVar = ConstraintValidator.class.getTypeParameters()[1];
        return TypeUtils.getRawType(typeVar, validatorClass);
    }

    protected Map<Class, ConstraintValidator> cache() {
        return this.validatorInstancesCache;
    }

    protected ConstraintValidator getCachedValidator(Class<?> type) {
        if (this.cache().containsKey(type)) {
            return this.cache().get(type);
        }
        ConstraintValidator validator = this.findAndInitializeValidator(type);
        this.cache().put(type, validator);
        return validator;
    }

    protected ConstraintValidator findAndInitializeValidator(Class<?> type) {
        LOG.trace("Looking for validator for type: {}", (Object)type.getName());
        for (Class clazz : this.validators.keySet()) {
            if (!clazz.isAssignableFrom(type)) continue;
            Class<ConstraintValidator<?, ?>> validatorClass = this.validators.get(clazz);
            LOG.trace("Initializing validator: {}", (Object)validatorClass.getName());
            ConstraintValidator validator = this.factory.getConstraintValidatorFactory().getInstance(validatorClass);
            return validator;
        }
        throw new IllegalArgumentException("No validator found for type: " + type.getName());
    }

    protected String readMessageTemplate(Annotation constraint) {
        return ReflectionUtils.invokeGetter("message", String.class, constraint);
    }

    protected String createMessage(ConstraintDescriptor descriptor, Object value) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(descriptor, value, Void.class);
        String template = this.readMessageTemplate(descriptor.getAnnotation());
        return this.factory.getMessageInterpolator().interpolate(template, (MessageInterpolator.Context)context);
    }
}

