/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection.support;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.Validate;

public class ReflectionUtils {
    public static <T> T[] invokeArrayGetter(String methodName, Class<T> returnType, Object object) throws IllegalArgumentException, IllegalStateException {
        Object result = ReflectionUtils.invokeNonArgMethod(methodName, object);
        Validate.isTrue((boolean)result.getClass().isArray(), (String)"Method %s should return array", (Object[])new Object[]{methodName});
        Validate.isInstanceOf(returnType, (Object)((Object[])result)[0], (String)"Method %s should return instance of %s[]", (Object[])new Object[]{methodName, returnType.getSimpleName()});
        return (Object[])result;
    }

    public static <T> T invokeGetter(String methodName, Class<T> returnType, Object object) throws IllegalArgumentException, IllegalStateException {
        Object result = ReflectionUtils.invokeNonArgMethod(methodName, object);
        Validate.isInstanceOf(returnType, (Object)result, (String)"Method %s should return instance of %s", (Object[])new Object[]{methodName, returnType.getSimpleName()});
        return (T)result;
    }

    public static Object invokeNonArgMethod(String methodName, Object object) {
        Class<?> clazz = object.getClass();
        try {
            return clazz.getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(String.format("Class should declare method %s()", methodName));
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ReflectionUtils() {
    }
}

