/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.spring;

import cz.jirutka.validator.spring.ReflectionUtils;
import cz.jirutka.validator.spring.SpELAssert;
import cz.jirutka.validator.spring.support.RelaxedBooleanTypeConverterDecorator;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.util.StringUtils;

public class SpELAssertValidator
implements ConstraintValidator<SpELAssert, Object>,
BeanFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpELAssertValidator.class);
    private static final TypeConverter TYPE_CONVERTER = new RelaxedBooleanTypeConverterDecorator((TypeConverter)new StandardTypeConverter());
    private Expression expression;
    private Expression applyIfExpression;
    private List<Method> functions = new LinkedList<Method>();
    private BeanFactory beanFactory;

    public void initialize(SpELAssert constraint) {
        SpelExpressionParser parser = new SpelExpressionParser();
        this.expression = parser.parseExpression(constraint.value());
        if (StringUtils.hasText((String)constraint.applyIf())) {
            this.applyIfExpression = parser.parseExpression(constraint.applyIf());
        }
        Class<?>[] classArray = constraint.helpers();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.functions = ReflectionUtils.extractStaticMethods(clazz);
            ++n2;
        }
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        if (object == null) {
            return true;
        }
        StandardEvaluationContext evalContext = this.createEvaluationContext(object);
        if (this.isApplyIfValid((EvaluationContext)evalContext)) {
            LOG.trace("Evaluating expression {{}} on object: {}", (Object)this.expression.getExpressionString(), object);
            return this.evaluate(this.expression, (EvaluationContext)evalContext);
        }
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private boolean isApplyIfValid(EvaluationContext context) {
        if (this.applyIfExpression == null) {
            return true;
        }
        LOG.trace("Evaluating applyIf {{}} on object: {}", (Object)this.applyIfExpression.getExpressionString(), (Object)context);
        return this.evaluate(this.applyIfExpression, context);
    }

    private boolean evaluate(Expression expression, EvaluationContext context) {
        Boolean result = (Boolean)expression.getValue(context, Boolean.class);
        return result == null ? false : result;
    }

    private StandardEvaluationContext createEvaluationContext(Object rootObject) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setRootObject(rootObject);
        context.setTypeConverter(TYPE_CONVERTER);
        if (this.beanFactory != null) {
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        }
        if (!this.functions.isEmpty()) {
            for (Method helper : this.functions) {
                context.registerFunction(helper.getName(), helper);
            }
            LOG.trace(this.inspectFunctions((EvaluationContext)context));
        }
        return context;
    }

    private String inspectFunctions(EvaluationContext context) {
        StringBuilder message = new StringBuilder();
        HashSet<String> names = new HashSet<String>(this.functions.size());
        message.append("Registered functions: \n");
        for (Method function : this.functions) {
            names.add(function.getName());
        }
        for (String name : names) {
            Object obj = context.lookupVariable(name);
            if (!(obj instanceof Method)) continue;
            message.append("     #").append(name).append(" -> ").append(obj).append("\n");
        }
        return message.toString();
    }
}

