/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast;

import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.DAY;
import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.TIME;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.NoDataFoundForThisDay;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.NoDataFoundForThisDayAndTime;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.AfterTomorrow;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.Today;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.Tomorrow;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour.ForecastAtHour;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour.IForecastDayTimesAndDays;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.jetbrains.annotations.NotNull;

public class WeatherForecast {
    private final Today today;
    private final Tomorrow tomorrow;
    private final AfterTomorrow tomorrowAfter;
    private final DAY[] days;
    private final TIME[] times;

    public WeatherForecast(@NotNull String location, @NotNull TIME time, DAY ... days) throws IOException {
        this(location, new TIME[]{time}, days);
    }

    public WeatherForecast(@NotNull String location, @NotNull DAY day, TIME ... times) throws IOException {
        this(location, times, day);
    }

    public WeatherForecast(@NotNull String location, @NotNull DAY[] day, TIME ... times) throws IOException {
        this(location, times, day);
    }

    public WeatherForecast(@NotNull String location, @NotNull TIME[] times, DAY ... days) throws IOException {
        Today todayHelper = null;
        Tomorrow tomorrowHelper = null;
        AfterTomorrow tomorrowAfterHelper = null;
        List<TIME> timeList = new ArrayList(Arrays.stream(times).collect(Collectors.toList())).stream().distinct().collect(Collectors.toList());
        List<DAY> dayList = new ArrayList(Arrays.stream(days).collect(Collectors.toList())).stream().distinct().collect(Collectors.toList());
        if (dayList.contains((Object)DAY.ALL)) {
            dayList = Arrays.stream(DAY.values()).collect(Collectors.toList()).stream().filter(day -> !day.equals((Object)DAY.ALL)).collect(Collectors.toList());
        }
        if (timeList.contains((Object)TIME.ALL)) {
            timeList = Arrays.stream(TIME.values()).collect(Collectors.toList()).stream().filter(time -> !time.equals((Object)TIME.ALL)).collect(Collectors.toList());
        }
        TIME[] timesBackToArray = timeList.toArray(new TIME[0]);
        this.times = timesBackToArray;
        this.days = dayList.toArray(new DAY[0]);
        for (DAY day2 : dayList) {
            switch (day2) {
                case TODAY: {
                    todayHelper = new Today(location, timesBackToArray);
                    break;
                }
                case TOMORROW: {
                    tomorrowHelper = new Tomorrow(location, timesBackToArray);
                    break;
                }
                case AFTER_TOMORROW: {
                    tomorrowAfterHelper = new AfterTomorrow(location, timesBackToArray);
                    break;
                }
                case ALL: {
                    todayHelper = new Today(location, timesBackToArray);
                    tomorrowHelper = new Tomorrow(location, timesBackToArray);
                    tomorrowAfterHelper = new AfterTomorrow(location, timesBackToArray);
                }
            }
        }
        this.today = todayHelper;
        this.tomorrow = tomorrowHelper;
        this.tomorrowAfter = tomorrowAfterHelper;
    }

    public static void clearSavedForecasts() {
        IForecastDayTimesAndDays.clearSavedForecasts();
    }

    public static void removedSavedForecast(ForecastAtHour forecast) {
        IForecastDayTimesAndDays.removedSavedForecast(forecast);
    }

    public ForecastAtHour getForecastFor(@NotNull DAY day, @NotNull TIME time) throws NoDataFoundForThisDayAndTime {
        return IForecastDayTimesAndDays.getMatchingObjectFrom(day, time);
    }

    public Map<DAY, Map<TIME, ForecastAtHour>> getAllForecastForAllDayAndAllTime() {
        HashMap<DAY, Map<TIME, ForecastAtHour>> returnMap = new HashMap<DAY, Map<TIME, ForecastAtHour>>();
        block5: for (DAY day : this.days) {
            switch (day) {
                case TODAY: {
                    returnMap.put(day, this.getToday().getAllForecastsForToday());
                    continue block5;
                }
                case TOMORROW: {
                    returnMap.put(day, this.getTomorrow().getAllForecastsForToday());
                    continue block5;
                }
                case AFTER_TOMORROW: {
                    returnMap.put(day, this.getTomorrowAfter().getAllForecastsForToday());
                }
            }
        }
        return returnMap;
    }

    public Today getToday() throws NoDataFoundForThisDay {
        if (this.today == null) {
            throw new NoDataFoundForThisDay("Today was not included in the constructor");
        }
        return this.today;
    }

    public Tomorrow getTomorrow() throws NoDataFoundForThisDay {
        if (this.tomorrow == null) {
            throw new NoDataFoundForThisDay("Tomorrow was not included in the constructor");
        }
        return this.tomorrow;
    }

    public AfterTomorrow getTomorrowAfter() throws NoDataFoundForThisDay {
        if (this.tomorrowAfter == null) {
            throw new NoDataFoundForThisDay("The day after tomorrow was not included in the constructor");
        }
        return this.tomorrowAfter;
    }

    public DAY[] getDays() {
        return this.days;
    }

    public TIME[] getTimes() {
        return this.times;
    }

    @CheckForNull
    public List<ForecastAtHour> getAllSavedForecasts() {
        return new ArrayList<ForecastAtHour>(UtilityClass.Storage.getListOfAllDaysAndItsTimes());
    }

    public void print() {
        new MethodRefPrint<WeatherForecast>(this).print();
    }

    public String toString() {
        return "---  WeatherForecast  ---\n--today=\n" + (this.today == null ? " null " : this.today.toString()) + "\n--tomorrow=\n" + (this.tomorrow == null ? " null " : this.tomorrow.toString()) + "\n--AfterTomorrow=\n" + (this.tomorrowAfter == null ? " null " : this.tomorrowAfter.toString());
    }
}

