/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects;

import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.DAY;
import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.TIME;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.CouldNotFindLocation;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.current_weather.CurrentCondition;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.WeatherForecast;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.nearest_area.NearestArea;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.request.Request;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONObject;

public final class WeatherObject {
    private final DAY[] days;
    private final TIME[] times;
    private final String location;
    private final JSONObject json;
    private final String jsonAsText;
    private final CurrentCondition currentCondition;
    private final NearestArea nearestArea;
    private final Request request;
    private final WeatherForecast weatherForecast;

    public WeatherObject(String location, TIME time, DAY ... days) throws IOException {
        this(location, new TIME[]{time}, days);
    }

    public WeatherObject(String location, DAY day, TIME ... times) throws IOException {
        this(location, times, day);
    }

    public WeatherObject(String location, DAY[] day, TIME ... times) throws IOException {
        this(location, times, day);
    }

    public WeatherObject(String location, TIME[] times, DAY ... days) throws IOException, CouldNotFindLocation {
        this.json = UtilityClass.getJson(location);
        this.jsonAsText = UtilityClass.WebPageReader.getTextFromWebpage("https://wttr.in/" + location + "?format=j1");
        this.location = location;
        this.days = days;
        this.times = times;
        this.currentCondition = new CurrentCondition(location);
        this.nearestArea = new NearestArea(location);
        this.request = new Request(location);
        this.weatherForecast = new WeatherForecast(location, times, days);
    }

    public DAY[] getDays() {
        return this.days;
    }

    public TIME[] getTimes() {
        return this.times;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public String getJsonAsText() {
        return this.jsonAsText;
    }

    public CurrentCondition getCurrentCondition() {
        return this.currentCondition;
    }

    public NearestArea getNearestArea() {
        return this.nearestArea;
    }

    public Request getRequest() {
        return this.request;
    }

    public WeatherForecast getWeatherForecast() {
        return this.weatherForecast;
    }

    public String getLocation() {
        return this.location;
    }

    public void print() {
        new MethodRefPrint<WeatherObject>(this).print();
    }

    public String toString() {
        return "---WeatherObject---\ndays=" + Arrays.toString((Object[])this.days) + "\ntimes=" + Arrays.toString((Object[])this.times) + "\nlocation='" + this.location + "'\njson=" + this.json + "\njsonAsText='" + this.jsonAsText + "'\ncurrentCondition=" + this.currentCondition.toString() + "\nnearestArea=" + this.nearestArea.toString() + "\nrequest=" + this.request.toString() + "\nweatherForecast=" + this.weatherForecast.toString();
    }
}

