/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour;

import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.DAY;
import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.TIME;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public final class ForecastAtHour {
    private final DAY day;
    private final TIME time;
    private final int dewPointC;
    private final int dewPointF;
    private final int feelsLikeC;
    private final int feelsLikeF;
    private final int heatIndexC;
    private final int heatIndexF;
    private final int windChillC;
    private final int windChillF;
    private final int windGustKmph;
    private final int windGustMiles;
    private final int chanceOfFog;
    private final int chanceOfFrost;
    private final int chanceOfHighTemperature;
    private final int chanceOfOvercast;
    private final int chanceOfRain;
    private final int chanceOfRemdry;
    private final int chanceOfSnow;
    private final int chanceOfSunshine;
    private final int chanceOfThunder;
    private final int chanceOfWindy;
    private final int cloudCover;
    private final int humidity;
    private final double precipInches;
    private final double precipMM;
    private final int pressure;
    private final int pressureInches;
    private final int temperatureC;
    private final int temperatureF;
    private final int timeInHundreds;
    private final int uvIndex;
    private final int visibility;
    private final int visibilityMiles;
    private final int weatherCode;
    private final String weatherDescription;
    private final String windDir16Point;
    private final int windDirDegree;
    private final int windSpeedKmph;
    private final int windSpeedMiles;

    public ForecastAtHour(@NotNull JSONObject startOfJsonObject, @NotNull DAY day, @NotNull TIME time) {
        this.day = day;
        this.time = time;
        JSONObject certHour = startOfJsonObject.getJSONArray("weather").getJSONObject(DAY.getIndex(day)).getJSONArray("hourly").getJSONObject(TIME.getIndex(time));
        this.dewPointC = certHour.getInt("DewPointC");
        this.dewPointF = certHour.getInt("DewPointF");
        this.feelsLikeC = certHour.getInt("FeelsLikeC");
        this.feelsLikeF = certHour.getInt("FeelsLikeF");
        this.heatIndexC = certHour.getInt("HeatIndexC");
        this.heatIndexF = certHour.getInt("HeatIndexF");
        this.windChillC = certHour.getInt("WindChillC");
        this.windChillF = certHour.getInt("WindChillF");
        this.windGustKmph = certHour.getInt("WindGustKmph");
        this.windGustMiles = certHour.getInt("WindGustMiles");
        this.chanceOfFog = certHour.getInt("chanceoffog");
        this.chanceOfFrost = certHour.getInt("chanceoffrost");
        this.chanceOfHighTemperature = certHour.getInt("chanceofhightemp");
        this.chanceOfOvercast = certHour.getInt("chanceofovercast");
        this.chanceOfRain = certHour.getInt("chanceofrain");
        this.chanceOfRemdry = certHour.getInt("chanceofremdry");
        this.chanceOfSnow = certHour.getInt("chanceofsnow");
        this.chanceOfSunshine = certHour.getInt("chanceofsunshine");
        this.chanceOfThunder = certHour.getInt("chanceofthunder");
        this.chanceOfWindy = certHour.getInt("chanceofwindy");
        this.cloudCover = certHour.getInt("cloudcover");
        this.humidity = certHour.getInt("humidity");
        this.precipInches = certHour.getDouble("precipInches");
        this.precipMM = certHour.getDouble("precipMM");
        this.pressure = certHour.getInt("pressure");
        this.pressureInches = certHour.getInt("pressureInches");
        this.temperatureC = certHour.getInt("tempC");
        this.temperatureF = certHour.getInt("tempF");
        this.timeInHundreds = certHour.getInt("time");
        this.uvIndex = certHour.getInt("uvIndex");
        this.visibility = certHour.getInt("visibility");
        this.visibilityMiles = certHour.getInt("visibilityMiles");
        this.weatherCode = certHour.getInt("weatherCode");
        this.weatherDescription = certHour.getJSONArray("weatherDesc").getJSONObject(0).getString("value");
        this.windDir16Point = certHour.getString("winddir16Point");
        this.windDirDegree = certHour.getInt("winddirDegree");
        this.windSpeedKmph = certHour.getInt("windspeedKmph");
        this.windSpeedMiles = certHour.getInt("windspeedMiles");
    }

    public int getDewPointC() {
        return this.dewPointC;
    }

    public int getDewPointF() {
        return this.dewPointF;
    }

    public int getFeelsLikeC() {
        return this.feelsLikeC;
    }

    public int getFeelsLikeF() {
        return this.feelsLikeF;
    }

    public int getHeatIndexC() {
        return this.heatIndexC;
    }

    public int getHeatIndexF() {
        return this.heatIndexF;
    }

    public int getWindChillC() {
        return this.windChillC;
    }

    public int getWindChillF() {
        return this.windChillF;
    }

    public int getWindGustKmph() {
        return this.windGustKmph;
    }

    public int getWindGustMiles() {
        return this.windGustMiles;
    }

    public int getChanceOfFog() {
        return this.chanceOfFog;
    }

    public int getChanceOfFrost() {
        return this.chanceOfFrost;
    }

    public int getChanceOfHighTemperature() {
        return this.chanceOfHighTemperature;
    }

    public int getChanceOfOvercast() {
        return this.chanceOfOvercast;
    }

    public int getChanceOfRain() {
        return this.chanceOfRain;
    }

    public int getChanceOfRemdry() {
        return this.chanceOfRemdry;
    }

    public int getChanceOfSnow() {
        return this.chanceOfSnow;
    }

    public int getChanceOfSunshine() {
        return this.chanceOfSunshine;
    }

    public int getChanceOfThunder() {
        return this.chanceOfThunder;
    }

    public int getChanceOfWindy() {
        return this.chanceOfWindy;
    }

    public int getCloudCover() {
        return this.cloudCover;
    }

    public int getHumidity() {
        return this.humidity;
    }

    public double getPrecipInches() {
        return this.precipInches;
    }

    public double getPrecipMM() {
        return this.precipMM;
    }

    public int getPressure() {
        return this.pressure;
    }

    public int getPressureInches() {
        return this.pressureInches;
    }

    public int getTemperatureC() {
        return this.temperatureC;
    }

    public int getTemperatureF() {
        return this.temperatureF;
    }

    public int getTimeInHundreds() {
        return this.timeInHundreds;
    }

    public int getUvIndex() {
        return this.uvIndex;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int getVisibilityMiles() {
        return this.visibilityMiles;
    }

    public int getWeatherCode() {
        return this.weatherCode;
    }

    public String getWeatherDescription() {
        return this.weatherDescription;
    }

    public String getWindDir16Point() {
        return this.windDir16Point;
    }

    public int getWindDirDegree() {
        return this.windDirDegree;
    }

    public int getWindSpeedKmph() {
        return this.windSpeedKmph;
    }

    public int getWindSpeedMiles() {
        return this.windSpeedMiles;
    }

    public DAY getDay() {
        return this.day;
    }

    public TIME getTime() {
        return this.time;
    }

    public void print() {
        new MethodRefPrint<ForecastAtHour>(this).print();
    }

    public String toString() {
        return "---ForecastAtHour---\nday=" + this.day + "\ntime=" + this.time + "\ndewPointC=" + this.dewPointC + "\ndewPointF=" + this.dewPointF + "\nfeelsLikeC=" + this.feelsLikeC + "\nfeelsLikeF=" + this.feelsLikeF + "\nheatIndexC=" + this.heatIndexC + "\nheatIndexF=" + this.heatIndexF + "\nwindChillC=" + this.windChillC + "\nwindChillF=" + this.windChillF + "\nwindGustKmph=" + this.windGustKmph + "\nwindGustMiles=" + this.windGustMiles + "\nchanceOfFog=" + this.chanceOfFog + "\nchanceOfFrost=" + this.chanceOfFrost + "\nchanceOfHighTemperature=" + this.chanceOfHighTemperature + "\nchanceOfOvercast=" + this.chanceOfOvercast + "\nchanceOfRain=" + this.chanceOfRain + "\nchanceOfRemdry=" + this.chanceOfRemdry + "\nchanceOfSnow=" + this.chanceOfSnow + "\nchanceOfSunshine=" + this.chanceOfSunshine + "\nchanceOfThunder=" + this.chanceOfThunder + "\nchanceOfWindy=" + this.chanceOfWindy + "\ncloudCover=" + this.cloudCover + "\nhumidity=" + this.humidity + "\nprecipInches=" + this.precipInches + "\nprecipMM=" + this.precipMM + "\npressure=" + this.pressure + "\npressureInches=" + this.pressureInches + "\ntemperatureC=" + this.temperatureC + "\ntemperatureF=" + this.temperatureF + "\ntimeInHundreds=" + this.timeInHundreds + "\nuvIndex=" + this.uvIndex + "\nvisibility=" + this.visibility + "\nvisibilityMiles=" + this.visibilityMiles + "\nweatherCode=" + this.weatherCode + "\nweatherDescription='" + this.weatherDescription + "'\nwindDir16Point='" + this.windDir16Point + "'\nwindDirDegree=" + this.windDirDegree + "\nwindSpeedKmph=" + this.windSpeedKmph + "\nwindSpeedMiles=" + this.windSpeedMiles;
    }
}

