/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days;

import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.DAY;
import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.TIME;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.CouldNotFindLocation;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.NoDataFoundForThisDayAndTime;
import cz.krystofcejchan.lite_weather_lib.utilities.IsNumeric;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour.ForecastAtHour;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour.IForecastDayTimesAndDays;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public final class Today
implements IForecastDayTimesAndDays {
    private final String location;
    private final int moonIllumination;
    private final String moonPhase;
    private final LocalTime moonRise;
    private final LocalTime moonSet;
    private final LocalTime sunSet;
    private final LocalTime sunRise;
    private final int averageTemperatureC;
    private final int averageTemperatureF;
    private final LocalDate date;
    private final int maxTemperatureC;
    private final int maxTemperatureF;
    private final int minTemperatureC;
    private final int minTemperatureF;
    private final double sunHour;
    private final double totalSnowCM;
    private final double totalSnowInches;
    private final int uvIndex;
    private final List<ForecastAtHour> forecastHourlyList = new ArrayList<ForecastAtHour>();
    private final TIME[] times;

    public Today(@NotNull String location, TIME ... times) throws CouldNotFindLocation {
        this.location = location;
        if (Arrays.asList(times).contains((Object)TIME.ALL)) {
            ArrayList<TIME> t = new ArrayList<TIME>();
            for (TIME time : TIME.values()) {
                if (time.equals((Object)TIME.ALL)) continue;
                t.add(time);
            }
            times = t.toArray(new TIME[0]);
        }
        this.times = times;
        JSONObject jsonObject = UtilityClass.getJson(location);
        JSONObject daily = jsonObject.getJSONArray("weather").getJSONObject(0).getJSONArray("astronomy").getJSONObject(0);
        this.moonIllumination = daily.getInt("moon_illumination");
        this.moonPhase = daily.getString("moon_phase");
        this.moonRise = IsNumeric.containsNumbers(daily.getString("moonrise")) ? UtilityClass.stringToLocalTime(new StringBuilder(daily.getString("moonrise"))) : null;
        this.moonSet = IsNumeric.containsNumbers(daily.getString("moonset")) ? UtilityClass.stringToLocalTime(new StringBuilder(daily.getString("moonset"))) : null;
        this.sunRise = IsNumeric.containsNumbers(daily.getString("sunrise")) ? UtilityClass.stringToLocalTime(new StringBuilder(daily.getString("sunrise"))) : null;
        this.sunSet = IsNumeric.containsNumbers(daily.getString("sunset")) ? UtilityClass.stringToLocalTime(new StringBuilder(daily.getString("sunset"))) : null;
        daily = jsonObject.getJSONArray("weather").getJSONObject(0);
        this.averageTemperatureC = daily.getInt("avgtempC");
        this.averageTemperatureF = daily.getInt("avgtempF");
        this.date = UtilityClass.stringToDate(new StringBuilder(daily.getString("date")));
        this.maxTemperatureC = daily.getInt("maxtempC");
        this.maxTemperatureF = daily.getInt("maxtempF");
        this.minTemperatureC = daily.getInt("mintempC");
        this.minTemperatureF = daily.getInt("mintempF");
        this.sunHour = daily.getDouble("sunHour");
        this.totalSnowCM = daily.getDouble("totalSnow_cm");
        this.totalSnowInches = this.totalSnowCM / 2.54;
        this.uvIndex = daily.getInt("uvIndex");
        for (TIME t : times) {
            IForecastDayTimesAndDays.super.addHour(new ForecastAtHour(jsonObject, this.getDay(), t));
        }
        System.gc();
    }

    @Override
    public DAY getDay() {
        return DAY.TODAY;
    }

    @Override
    public TIME[] getTime() {
        return this.times;
    }

    @Override
    @NotNull
    public ForecastAtHour getForecastByTime(@NotNull TIME time) throws NoDataFoundForThisDayAndTime {
        return IForecastDayTimesAndDays.getMatchingObjectFrom(this.getDay(), time);
    }

    @NotNull
    public Map<TIME, ForecastAtHour> getAllForecastsForToday() {
        HashMap<TIME, ForecastAtHour> map = new HashMap<TIME, ForecastAtHour>();
        for (TIME time : this.getTime()) {
            try {
                map.put(time, this.getForecastByTime(time));
            }
            catch (NoDataFoundForThisDayAndTime exception) {
                exception.printStackTrace();
            }
        }
        return map;
    }

    public int getMoonIllumination() {
        return this.moonIllumination;
    }

    public String getMoonPhase() {
        return this.moonPhase;
    }

    public LocalTime getMoonRise() {
        return this.moonRise;
    }

    public LocalTime getMoonSet() {
        return this.moonSet;
    }

    public LocalTime getSunSet() {
        return this.sunSet;
    }

    public LocalTime getSunRise() {
        return this.sunRise;
    }

    public int getAverageTemperatureC() {
        return this.averageTemperatureC;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public int getMaxTemperatureC() {
        return this.maxTemperatureC;
    }

    public int getMaxTemperatureF() {
        return this.maxTemperatureF;
    }

    public int getMinTemperatureC() {
        return this.minTemperatureC;
    }

    public int getMinTemperatureF() {
        return this.minTemperatureF;
    }

    public double getSunHour() {
        return this.sunHour;
    }

    public double getTotalSnowCM() {
        return this.totalSnowCM;
    }

    public double getTotalSnowInches() {
        return this.totalSnowInches;
    }

    public int getUvIndex() {
        return this.uvIndex;
    }

    public List<ForecastAtHour> getForecastHourlyList() {
        return this.forecastHourlyList;
    }

    public void print() {
        new MethodRefPrint<Today>(this).print();
    }

    public String getLocation() {
        return this.location;
    }

    public int getAverageTemperatureF() {
        return this.averageTemperatureF;
    }

    public TIME[] getTimes() {
        return this.times;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "---Today---\ntimes=" + Arrays.toString((Object[])this.times) + "\noonIllumination=" + this.moonIllumination + "\nmoonPhase='" + this.moonPhase + "'\nmoonRise=" + this.moonRise + "\nmoonSet=" + this.moonSet + "\nsunSet=" + this.sunSet + "\nsunRise=" + this.sunRise + "\naverageTemperatureC=" + this.averageTemperatureC + "\naverageTemperatureF=" + this.averageTemperatureF + "\ndate=" + this.date + "\nmaxTemperatureC=" + this.maxTemperatureC + "\nmaxTemperatureF=" + this.maxTemperatureF + "\nminTemperatureC=" + this.minTemperatureC + "\nminTemperatureF=" + this.minTemperatureF + "\nsunHour=" + this.sunHour + "\ntotalSnowCM=" + this.totalSnowCM + "\ntotalSnowInches=" + this.totalSnowInches + "\nuvIndex=" + this.uvIndex + "\nforecastHourlyList=" + this.forecastHourlyList;
    }
}

