/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour;

import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.DAY;
import cz.krystofcejchan.lite_weather_lib.enums_exception.enums.TIME;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.CannotSearchForAll;
import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.NoDataFoundForThisDayAndTime;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.forecast.days.hour.ForecastAtHour;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface IForecastDayTimesAndDays {
    @NotNull
    public static ForecastAtHour getMatchingObjectFrom(DAY day, TIME time) throws NoDataFoundForThisDayAndTime, CannotSearchForAll {
        if (day.equals((Object)DAY.ALL) || time.equals((Object)TIME.ALL)) {
            throw new CannotSearchForAll("In order to get Forecast for certain hour, you need to pass any DAY or TIME except ALL");
        }
        return UtilityClass.Storage.getListOfAllDaysAndItsTimes().stream().filter(f -> f.getDay().equals((Object)day) && f.getTime().equals((Object)time)).findFirst().orElseThrow(() -> new NoDataFoundForThisDayAndTime("No data found for such day and time"));
    }

    public static void clearSavedForecasts() {
        UtilityClass.Storage.clearList();
    }

    public static void removedSavedForecast(ForecastAtHour forecast) {
        UtilityClass.Storage.removeElement(forecast);
    }

    public DAY getDay();

    public TIME[] getTime();

    public ForecastAtHour getForecastByTime(TIME var1) throws NoDataFoundForThisDayAndTime;

    default public void addHour(ForecastAtHour forecast) {
        List<ForecastAtHour> forecastHourlyList = UtilityClass.Storage.getListOfAllDaysAndItsTimes();
        if (forecastHourlyList.stream().noneMatch(it -> it.equals(forecast))) {
            forecastHourlyList.add(forecast);
            UtilityClass.Storage.addToListOfAllDaysAndItsTimes(forecast);
        }
    }
}

