/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.current_weather;

import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.CouldNotFindLocation;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public final class CurrentCondition {
    private final String location;
    private final int feelsLikeC;
    private final int feelsLikeF;
    private final int cloudCover;
    private final int humidity;
    private final LocalDateTime localObsDateTime;
    private final LocalTime observationTime;
    private final double precipInches;
    private final double precipMM;
    private final int pressure;
    private final int pressureInches;
    private final int temp_C;
    private final int temp_F;
    private final int uvIndex;
    private final int visibility;
    private final int visibilityMiles;
    private final int weatherCode;
    private final String weatherDescription;
    private final String windDir16Point;
    private final int winDirDegree;
    private final int windSpeedKmph;
    private final int windSpeedMiles;

    public CurrentCondition(@NotNull String location) throws CouldNotFindLocation {
        this.location = location;
        JSONObject current_condition = UtilityClass.getJson(location).getJSONArray("current_condition").getJSONObject(0);
        StringBuilder locObsDateT = new StringBuilder(current_condition.getString("localObsDateTime").trim().toUpperCase(Locale.ROOT));
        StringBuilder obsT = new StringBuilder(current_condition.getString("observation_time").trim().toUpperCase(Locale.ROOT));
        this.localObsDateTime = UtilityClass.stringToDateTime(locObsDateT);
        this.feelsLikeC = current_condition.getInt("FeelsLikeC");
        this.feelsLikeF = current_condition.getInt("FeelsLikeF");
        this.cloudCover = current_condition.getInt("cloudcover");
        this.humidity = current_condition.getInt("humidity");
        this.observationTime = UtilityClass.stringToLocalTime(obsT);
        this.precipInches = current_condition.getDouble("precipInches");
        this.precipMM = current_condition.getDouble("precipMM");
        this.pressure = current_condition.getInt("pressure");
        this.pressureInches = current_condition.getInt("pressureInches");
        this.temp_C = current_condition.getInt("temp_C");
        this.temp_F = current_condition.getInt("temp_F");
        this.uvIndex = current_condition.getInt("uvIndex");
        this.visibility = current_condition.getInt("visibility");
        this.visibilityMiles = current_condition.getInt("visibilityMiles");
        this.weatherCode = current_condition.getInt("weatherCode");
        this.weatherDescription = current_condition.getJSONArray("weatherDesc").getJSONObject(0).getString("value");
        this.windDir16Point = current_condition.getString("winddir16Point");
        this.winDirDegree = current_condition.getInt("winddirDegree");
        this.windSpeedKmph = current_condition.getInt("windspeedKmph");
        this.windSpeedMiles = current_condition.getInt("windspeedMiles");
    }

    public int getFeelsLikeC() {
        return this.feelsLikeC;
    }

    public int getFeelsLikeF() {
        return this.feelsLikeF;
    }

    public int getCloudCover() {
        return this.cloudCover;
    }

    public int getHumidity() {
        return this.humidity;
    }

    public LocalDateTime getLocalObsDateTime() {
        return this.localObsDateTime;
    }

    public LocalTime getObservationTime() {
        return this.observationTime;
    }

    public double getPrecipInches() {
        return this.precipInches;
    }

    public double getPrecipMM() {
        return this.precipMM;
    }

    public int getPressure() {
        return this.pressure;
    }

    public int getPressureInches() {
        return this.pressureInches;
    }

    public int getTemp_C() {
        return this.temp_C;
    }

    public int getTemp_F() {
        return this.temp_F;
    }

    public int getUvIndex() {
        return this.uvIndex;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int getVisibilityMiles() {
        return this.visibilityMiles;
    }

    public int getWeatherCode() {
        return this.weatherCode;
    }

    public String getWeatherDescription() {
        return this.weatherDescription;
    }

    public String getWindDir16Point() {
        return this.windDir16Point;
    }

    public int getWinDirDegree() {
        return this.winDirDegree;
    }

    public int getWindSpeedKmph() {
        return this.windSpeedKmph;
    }

    public int getWindSpeedMiles() {
        return this.windSpeedMiles;
    }

    public void print() {
        new MethodRefPrint<CurrentCondition>(this).print();
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "--CurrentCondition--\nfeelsLikeC=" + this.feelsLikeC + "\nfeelsLikeF=" + this.feelsLikeF + "\ncloudCover=" + this.cloudCover + "\nhumidity=" + this.humidity + "\nlocalObsDateTime=" + this.localObsDateTime + "\nobservationTime=" + this.observationTime + "\nprecipInches=" + this.precipInches + "\nprecipMM=" + this.precipMM + "\npressure=" + this.pressure + "\npressureInches=" + this.pressureInches + "\ntemp_C=" + this.temp_C + "\ntemp_F=" + this.temp_F + "\nuvIndex=" + this.uvIndex + "\nvisibility=" + this.visibility + "\nvisibilityMiles=" + this.visibilityMiles + "\nweatherCode=" + this.weatherCode + "\nweatherDescription='" + this.weatherDescription + "'\nwindDir16Point='" + this.windDir16Point + "'\nwinDirDegree=" + this.winDirDegree + "\nwindSpeedKmph=" + this.windSpeedKmph + "\nwindSpeedMiles=" + this.windSpeedMiles + "\n---";
    }
}

