/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.nearest_area;

import cz.krystofcejchan.lite_weather_lib.enums_exception.exceptions.CouldNotFindLocation;
import cz.krystofcejchan.lite_weather_lib.utilities.UtilityClass;
import cz.krystofcejchan.lite_weather_lib.weather_objects.MethodRefPrint;
import cz.krystofcejchan.lite_weather_lib.weather_objects.subparts.nearest_area.details.AreaInfo;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public final class NearestArea {
    private final String country;
    private final AreaInfo areaInfo;

    public NearestArea(@NotNull String location) throws CouldNotFindLocation {
        JSONObject nearest_area = UtilityClass.getJson(location).getJSONArray("nearest_area").getJSONObject(0);
        String v = "value";
        this.country = nearest_area.getJSONArray("country").getJSONObject(0).getString(v);
        this.areaInfo = new AreaInfo(nearest_area.getJSONArray("areaName").getJSONObject(0).getString(v), nearest_area.getString("latitude"), nearest_area.getString("longitude"), nearest_area.getString("population"), nearest_area.getJSONArray("region").getJSONObject(0).getString(v));
    }

    public String getCountry() {
        return this.country;
    }

    public AreaInfo getAreaInfo() {
        return this.areaInfo;
    }

    public void print() {
        new MethodRefPrint<NearestArea>(this).print();
    }

    public String toString() {
        return "--NearestArea--\ncountry='" + this.country + "\nareaInfo=" + this.areaInfo.toString();
    }
}

