/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.ds.r_tree_based;

import cz.krystofcejchan.ds.r_tree_based.MVRLeafRef;
import cz.krystofcejchan.ds.r_tree_based.MVRTree;
import cz.krystofcejchan.ds.r_tree_based.R3Entry;
import cz.krystofcejchan.ds.r_tree_based.RTree3D;
import cz.krystofcejchan.model.BoundingBox2D;
import cz.krystofcejchan.model.BoundingBox3D;
import cz.krystofcejchan.model.TimeInterval;
import cz.krystofcejchan.model.interfaces.SpatioTemporalIndex;
import cz.krystofcejchan.model.interfaces.SpatioTemporalObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class MV3RTreeIndex<T>
implements SpatioTemporalIndex<T> {
    private final MVRTree<T> mvr;
    private final RTree3D<T> r3d;
    private long intervalThresholdSeconds = 86400L;

    public MV3RTreeIndex(int maxEntries) {
        this.mvr = new MVRTree(maxEntries);
        this.r3d = new RTree3D(Math.max(8, maxEntries / 2));
    }

    public void setIntervalThresholdSeconds(long seconds) {
        this.intervalThresholdSeconds = Math.max(0L, seconds);
    }

    public long getIntervalThresholdSeconds() {
        return this.intervalThresholdSeconds;
    }

    @Override
    public void insert(SpatioTemporalObject<T> obj) {
        List<MVRLeafRef> newLeaves = this.mvr.insert(obj);
        for (MVRLeafRef leaf : newLeaves) {
            BoundingBox2D b2 = leaf.box();
            TimeInterval ti = leaf.interval();
            BoundingBox3D b3 = BoundingBox3D.from2DAndTime(b2, ti);
            this.r3d.insert(new R3Entry(b3, leaf.payloadId()));
        }
    }

    @Override
    public void delete(Object key, Instant deletionTime) {
        if (deletionTime == null) {
            deletionTime = Instant.now();
        }
        List<MVRLeafRef> affected = this.mvr.logicalDelete(key, deletionTime);
        for (MVRLeafRef leaf : affected) {
            this.r3d.updateEndTime(leaf.payloadId(), deletionTime);
        }
    }

    @Override
    public List<SpatioTemporalObject<T>> query(BoundingBox2D area) {
        Instant now = Instant.now();
        return this.mvr.query(area, TimeInterval.instant(now));
    }

    @Override
    public List<SpatioTemporalObject<T>> query(TimeInterval interval) {
        BoundingBox3D big = BoundingBox3D.FULL_2D.withTime(interval);
        return this.collectByIds(this.r3d.search(big));
    }

    @Override
    public List<SpatioTemporalObject<T>> query(BoundingBox2D area, TimeInterval interval) {
        if (interval == null || interval.isInstant()) {
            return this.mvr.query(area, interval != null ? interval : TimeInterval.instant(Instant.now()));
        }
        long span = Math.max(0L, interval.durationSeconds());
        if (span >= this.intervalThresholdSeconds) {
            BoundingBox3D b3 = BoundingBox3D.from2DAndTime(area, interval);
            return this.collectByIds(this.r3d.search(b3));
        }
        return this.mvr.query(area, interval);
    }

    private List<SpatioTemporalObject<T>> collectByIds(Collection<UUID> ids) {
        ArrayList<SpatioTemporalObject<T>> out = new ArrayList<SpatioTemporalObject<T>>();
        for (UUID id : ids) {
            SpatioTemporalObject<T> o = this.mvr.getById(id);
            if (o == null) continue;
            out.add(o);
        }
        return out;
    }
}

