/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.model;

import org.jetbrains.annotations.NotNull;

public record BoundingBox2D(double minX, double minY, double maxX, double maxY) {
    public BoundingBox2D {
        if (minX > maxX || minY > maxY) {
            throw new IllegalArgumentException("invalid box");
        }
    }

    public boolean intersects(BoundingBox2D o) {
        return !(o.minX > this.maxX || o.maxX < this.minX || o.minY > this.maxY || o.maxY < this.minY);
    }

    public static BoundingBox2D union(BoundingBox2D a, BoundingBox2D b) {
        return new BoundingBox2D(Math.min(a.minX, b.minX), Math.min(a.minY, b.minY), Math.max(a.maxX, b.maxX), Math.max(a.maxY, b.maxY));
    }

    public double area() {
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("BBox[%.3f,%.3f..%.3f,%.3f]", this.minX, this.minY, this.maxX, this.maxY);
    }
}

