/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.model;

import cz.krystofcejchan.model.BoundingBox2D;
import cz.krystofcejchan.model.R2Entry;
import java.util.ArrayList;
import java.util.List;

public final class Node2D<E extends R2Entry> {
    private final boolean isLeaf;
    private final List<E> entries = new ArrayList();
    private Node2D<E> parent;
    private BoundingBox2D cachedMBR;

    public Node2D(boolean leaf) {
        this.isLeaf = leaf;
    }

    public void recalcMBR() {
        BoundingBox2D b = null;
        for (R2Entry e : this.entries) {
            b = b == null ? e.getMbr() : BoundingBox2D.union(b, e.getMbr());
        }
        this.cachedMBR = b;
    }

    public BoundingBox2D mbr() {
        if (this.cachedMBR == null) {
            this.recalcMBR();
        }
        return this.cachedMBR;
    }

    public double mbrArea() {
        BoundingBox2D b = this.mbr();
        return b == null ? 0.0 : b.area();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public List<E> getEntries() {
        return this.entries;
    }

    public Node2D<E> getParent() {
        return this.parent;
    }

    public void setParent(Node2D<E> parent) {
        this.parent = parent;
    }

    public BoundingBox2D getCachedMBR() {
        return this.cachedMBR;
    }

    public void setCachedMBR(BoundingBox2D cachedMBR) {
        this.cachedMBR = cachedMBR;
    }
}

