/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.model;

import java.time.Instant;

public final class TimeInterval {
    public final Instant start;
    public final Instant end;
    public static final Instant END_OF_TIME = Instant.MAX;

    private TimeInterval(Instant start, Instant end) {
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("start > end");
        }
        this.start = start;
        this.end = end;
    }

    public static TimeInterval of(Instant start, Instant end) {
        return new TimeInterval(start, end);
    }

    public static TimeInterval instant(Instant t) {
        return new TimeInterval(t, t);
    }

    public boolean overlaps(TimeInterval other) {
        return !this.start.isAfter(other.end) && !other.start.isAfter(this.end);
    }

    public boolean contains(Instant t) {
        return !t.isBefore(this.start) && !t.isAfter(this.end);
    }

    public boolean isInstant() {
        return this.start.equals(this.end);
    }

    public long durationSeconds() {
        return this.end.getEpochSecond() - this.start.getEpochSecond();
    }

    public TimeInterval withEnd(Instant newEnd) {
        return new TimeInterval(this.start, newEnd);
    }
}

