/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.base_ds;

import cz.krystofcejchan.model.BoundingBox2D;
import cz.krystofcejchan.model.Node2D;
import cz.krystofcejchan.model.R2Entry;
import cz.krystofcejchan.utils.classes.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRTree2D<E extends R2Entry> {
    protected final int M;
    protected Node2D<E> root;

    protected AbstractRTree2D(int maxEntries) {
        this.M = Math.max(4, maxEntries);
        this.root = new Node2D(true);
    }

    protected void insertEntry(E e) {
        Node2D<E> leaf = this.chooseLeaf(this.root, e);
        leaf.getEntries().add(e);
        this.adjustMBRUpwards(leaf);
        if (leaf.getEntries().size() > this.M) {
            this.splitNode(leaf);
        }
    }

    protected List<E> search(BoundingBox2D box) {
        ArrayList out = new ArrayList();
        this.searchRec(this.root, box, out);
        return out;
    }

    private void searchRec(Node2D<E> n, BoundingBox2D box, List<E> out) {
        if (n.isLeaf()) {
            for (R2Entry e : n.getEntries()) {
                if (!e.getMbr().intersects(box)) continue;
                out.add(e);
            }
        } else {
            for (R2Entry e : n.getEntries()) {
                if (!e.getMbr().intersects(box)) continue;
                this.searchRec(this.cast(e.getChild()), box, out);
            }
        }
    }

    private Node2D<E> chooseLeaf(Node2D<E> n, E e) {
        if (n.isLeaf()) {
            return n;
        }
        Node2D<E> bestChild = null;
        double bestInc = Double.longBitsToDouble(0x7FF0000000000000L);
        for (R2Entry ce : n.getEntries()) {
            double oldArea = ce.getMbr().area();
            BoundingBox2D uni = BoundingBox2D.union(ce.getMbr(), ((R2Entry)e).getMbr());
            double inc = uni.area() - oldArea;
            if (inc < bestInc) {
                bestInc = inc;
                bestChild = this.cast(ce.getChild());
                continue;
            }
            if (inc != bestInc) continue;
            assert (bestChild != null);
            if (!(this.cast(ce.getChild()).mbrArea() < bestChild.mbrArea())) continue;
            bestChild = this.cast(ce.getChild());
        }
        assert (bestChild != null);
        return this.chooseLeaf(bestChild, e);
    }

    private void adjustMBRUpwards(Node2D<E> n) {
        while (n != null) {
            n.recalcMBR();
            n = n.getParent();
        }
    }

    private void splitNode(Node2D<E> n) {
        Pair<E, E> seeds = this.pickSeeds(n.getEntries());
        Node2D n1 = new Node2D(n.isLeaf());
        Node2D n2 = new Node2D(n.isLeaf());
        n1.setParent(n.getParent());
        n2.setParent(n.getParent());
        n1.getEntries().add((R2Entry)seeds.a());
        n2.getEntries().add((R2Entry)seeds.b());
        ArrayList<E> rem = new ArrayList<E>(n.getEntries());
        rem.remove(seeds.a());
        rem.remove(seeds.b());
        while (!rem.isEmpty()) {
            double inc2;
            R2Entry e2 = (R2Entry)rem.removeLast();
            double inc1 = this.areaIncrease(n1, e2);
            if (inc1 < (inc2 = this.areaIncrease(n2, e2))) {
                n1.getEntries().add(e2);
                continue;
            }
            if (inc2 < inc1) {
                n2.getEntries().add(e2);
                continue;
            }
            if (this.mbrArea(n1) < this.mbrArea(n2)) {
                n1.getEntries().add(e2);
                continue;
            }
            n2.getEntries().add(e2);
        }
        if (!n1.isLeaf()) {
            for (R2Entry e3 : n1.getEntries()) {
                this.cast(e3.getChild()).setParent(n1);
            }
        }
        if (!n2.isLeaf()) {
            for (R2Entry e4 : n2.getEntries()) {
                this.cast(e4.getChild()).setParent(n2);
            }
        }
        n1.recalcMBR();
        n2.recalcMBR();
        if (n.getParent() == null) {
            Node2D newRoot = new Node2D(false);
            newRoot.getEntries().add(this.makeInternal(n1.mbr(), n1));
            newRoot.getEntries().add(this.makeInternal(n2.mbr(), n2));
            n1.setParent(newRoot);
            n2.setParent(newRoot);
            this.root = newRoot;
        } else {
            Node2D<E> p;
            p.getEntries().removeIf(e -> e.getChild() == n);
            p.getEntries().add(this.makeInternal(n1.mbr(), n1));
            p.getEntries().add(this.makeInternal(n2.mbr(), n2));
            for (p = n.getParent(); p != null; p = p.getParent()) {
                if (p.getEntries().size() > this.M) {
                    this.splitNode(p);
                }
                p.recalcMBR();
            }
        }
    }

    protected abstract E makeInternal(BoundingBox2D var1, Node2D<E> var2);

    private Node2D<E> cast(Node2D<? extends R2Entry> n) {
        return n;
    }

    private double mbrArea(Node2D<E> n) {
        return n.mbrArea();
    }

    private double areaIncrease(Node2D<E> n, R2Entry e) {
        BoundingBox2D uni = BoundingBox2D.union(n.mbr(), e.getMbr());
        return uni.area() - n.mbrArea();
    }

    private Pair<E, E> pickSeeds(List<E> es) {
        double worstWaste = -1.0;
        R2Entry s1 = null;
        R2Entry s2 = null;
        for (int i = 0; i < es.size(); ++i) {
            for (int j = i + 1; j < es.size(); ++j) {
                R2Entry a = (R2Entry)es.get(i);
                R2Entry b = (R2Entry)es.get(j);
                double d = BoundingBox2D.union(a.getMbr(), b.getMbr()).area() - a.getMbr().area() - b.getMbr().area();
                if (!(d > worstWaste)) continue;
                worstWaste = d;
                s1 = a;
                s2 = b;
            }
        }
        return new Pair<Object, Object>(s1, s2);
    }
}

